PROGRAM QSort;    {(c) ALFWARE B.Schubert V4.30 03/2011}

{$IFDEF DOS} {$M 65520,0,655360} {$ENDIF}
USES STRINGS, DOS;

CONST feld:ARRAY[0..9] OF CHAR =
      ('A','B','C','D','E','F','G','H','I','J');
      keylang:   LONGINT    = 133;
      reverse:   BOOLEAN    = FALSE;
      buffermax: LONGINT    = 0;
      abspalte:  LONGINT    = 1;
      tempbest:  STRING[8]  = '_TEMP_';
      tempverz:  STRING     = '';
      funktion:  BYTE       = 7;
      temploes:  BOOLEAN    = TRUE;
      bufferdyn: BOOLEAN    = FALSE;
      temperst:  LONGINT    = 1;
      dynlaenge: LONGINT    = 2000;
      einname:   STRING     = '';
      einok:     BOOLEAN    = FALSE;
      zeilenmax: LONGINT    = maxlongint;
      ZAEHLEN:   BOOLEAN    = TRUE;
      TEILE = 0; SORTIERE = 1; MISCHE = 2;

TYPE  SCHLUESSEL = PCHAR;
      ZEIGER = ^SATZ;
      SATZ = RECORD
         link: ZEIGER;
         key: SCHLUESSEL;
      END;
      STRING16 = STRING[16];

VAR anker: ZEIGER;
    zeile0,stra,strb: STRING;
    datei: ARRAY[1..15] OF RECORD
       name: TEXT;
       zeile: STRING;
       io: BOOLEAN;
    END;
    {$IFDEF DOS}
    heap:POINTER;
    {$ELSE}
    HeapStatusFPC: TFPCHeapStatus;
    {$ENDIF}
    zeilenzahl: LONGINT;
    eindatei: TEXT;

PROCEDURE PARAMETER(p: STRING);
VAR i,j: LONGINT; k:INTEGER;
    tname: STRING;
BEGIN
   IF POS('?',p)+POS('H',p)+POS('h',p)<>0 THEN BEGIN
      WriteLN;
      {$IFDEF DOS}
      WriteLN(' QSORT   Sortierprogramm   V 4.30 (16bit)   03/2011','':5,'(c) ALFWARE B.Schubert');
      {$ELSE}
      WriteLN(' QSORT   Sortierprogramm   V 4.30   03/2011','':13,'(c) ALFWARE B.Schubert');
      {$ENDIF}
      WriteLN;
      WriteLN(' QSORT [/R] [/+n] [/Ln] [/Bn] < einfile > ausfile'); WriteLN;
      WriteLN('   /R  ... reverse Sortierreihenfolge: ABSTEIGEND',
              '':7,'(Standard: AUFSTEIGEND)');
      WriteLN('   /+n ... Sortieren erst ab Spalte n','':19,'(Standard: 1)');
      WriteLN('   /Ln ... max.Lnge der zu sortierenden Stze',
              '':10,'(Standard: 133)');
      WriteLN('   /Bn ... Anzahl Puffer (auf Festplatte) 1..[15]..999  ',
              '(Standard: 0)');
      WriteLN('   /Dn ... dynamische Pufferanzahl (berschreibt /B)    ',
              '(Standard: AUS)');
      WriteLN('           n = Zeilen pro Puffer bei /D',
              '':17,'(Standard: 2000)');
      WriteLN('   /Nf ... Name der temporren Bestnde',
              '':17,'(Standard: _TEMP_)');
      WriteLN('   /P  ... Nutze das TEMP-Verzeichnis (nur bis /B15)',
              '':4,'(Standard: NICHT)');
      WriteLN('   /T  ... temporre Bestnde nicht lschen',
              '':13,'(Standard: LSCHEN)');
      WriteLN('   /En ... Index des ersten temporren Bestands',
              '':9,'(Standard: 1)');
      WriteLN('   /Fn ... Funktionsumfang: 1=TEILE 2=SORT 4=MERGE',
              '':6,'(Standard: 7 = alle)');
      WriteLN('':28,'0=ZHLE');
      WriteLN('   /Idn... Eingabedatei, dann keine < Umleitung mglich',
              ' (Standard: INPUT)');
      WriteLN('   /Zn ... Sortiere nur max. n Zeilen der Eingabe','':7,
              '(Standard: ALLE)');
      WriteLN;
      HALT;
   END;
   FOR i:=1 TO PARAMCOUNT DO BEGIN
      p:=PARAMSTR(i); VAL(COPY(p,3,255),j,k); tname:=COPY(p,3,255);
      IF p[1] IN ['/','-'] THEN
        CASE p[2] OF
         'R','r': reverse:=TRUE;
         '+':     IF (j>0) AND (j<=keylang) THEN abspalte:=j;
         'L','l': IF (j>0) AND (j<=255) THEN keylang:=j;
         'B','b': BEGIN
                     IF k=0
                        THEN IF (j>=0) AND (j<=999) THEN buffermax:=j ELSE
                        ELSE buffermax:=15;
                  END;
         'D','d': BEGIN bufferdyn:=TRUE; IF j<>0 THEN dynlaenge:=j END;
         'N','n': IF tname<>'' THEN tempbest:=tname;
         'P','p': BEGIN
                     tempverz:=GetEnv('TEMP');
                     IF tempverz='' THEN tempverz:=GetEnv('TMP');
                  END;
         'T','t': temploes:=FALSE;
         'E','e': IF (j>0) AND (j<=999) THEN temperst:=j;
         'F','f': IF (j>=0) AND (j<=7) THEN funktion:=j;
         'I','i': IF tname<>'' THEN einname:=tname;
         'Z','z': IF (j>0) THEN BEGIN zeilenmax:=j; ZAEHLEN:=FALSE; END;
      END;
   END;
   IF temperst+buffermax-1>999 THEN HALT;
   IF bufferdyn THEN BEGIN;
      IF funktion MOD 2 = 0
         THEN bufferdyn:=FALSE
         ELSE BEGIN temperst:=1; buffermax:=1; END;
   END;
END;

FUNCTION VERGLEICH(a,b: SCHLUESSEL):BOOLEAN;
VAR s,i,l: LONGINT;
BEGIN
   IF reverse
      THEN BEGIN stra:=STRPAS(b); strb:=STRPAS(a); END
      ELSE BEGIN stra:=STRPAS(a); strb:=STRPAS(b); END;
   i:=abspalte; s:=0;
   l:=LENGTH(stra); IF l > LENGTH(strb) THEN l:=LENGTH(strb);
   WHILE (s = 0) AND (i <= l) DO BEGIN
      IF stra[i] < strb[i] THEN s:=-1 ELSE
      IF stra[i] > strb[i] THEN s:=1;
      INC(i);
   END;
   CASE s OF
    -1: VERGLEICH:=TRUE;
     1: VERGLEICH:=FALSE;
     0: VERGLEICH:=LENGTH(stra) <= LENGTH(strb)
   END;
END;

PROCEDURE QUICK(VAR pointer: ZEIGER);
VAR plinks,prechts,ptemp,ptest: ZEIGER;
BEGIN
   IF (pointer<>NIL) AND (pointer^.link<>NIL) THEN BEGIN
      ptemp:=pointer; pointer:=pointer^.link;
      plinks:=NIL; prechts:=NIL;
      WHILE pointer<>NIL DO BEGIN
         ptest:=pointer; pointer:=pointer^.link;
         IF VERGLEICH(ptest^.key,ptemp^.key)
           THEN BEGIN ptest^.link:=plinks;  plinks:=ptest; END
           ELSE BEGIN ptest^.link:=prechts; prechts:=ptest; END;
      END;
      QUICK(plinks); QUICK(prechts);
      ptemp^.link:=prechts;
      IF plinks=NIL
         THEN pointer:=ptemp
         ELSE BEGIN
            pointer:=plinks;
            WHILE plinks^.link<>NIL DO plinks:=plinks^.link;
            plinks^.link:=ptemp;
         END;
   END;
END;

FUNCTION FUNK_ERLAUBT(funktion,code: BYTE):BOOLEAN;
BEGIN
   CASE code OF
      TEILE:    FUNK_ERLAUBT:=funktion IN [1,3,5,7];
      SORTIERE: FUNK_ERLAUBT:=funktion IN [2,3,6,7];
      MISCHE:   FUNK_ERLAUBT:=funktion IN [4..7];
   END;
END;

FUNCTION All_EOF(buffer: LONGINT):BOOLEAN;
VAR d: LONGINT;
BEGIN
   d:=1; WHILE (d<=buffer) AND NOT datei[d].io DO INC(d);
   All_EOF:=(d>buffer);
END;

PROCEDURE READDATEI(dn: LONGINT);
BEGIN
   datei[dn].io:=NOT EOF(datei[dn].name);
   IF datei[dn].io THEN ReadLN(datei[dn].name,datei[dn].zeile);
END;

FUNCTION Str0(n,anz:INTEGER):STRING;
VAR s0,s1:STRING; i:INTEGER;
BEGIN
  STR(n,s0); s1:='';
  FOR i:=anz-LENGTH(s0) DOWNTO 1 DO s1:=s1+'0';
  Str0:=s1+s0;
END;

FUNCTION StrLong(n,anz:LONGINT):STRING;
VAR s0,s1:STRING; i,j:INTEGER;
BEGIN
  STR(n,s0); s1:=''; j:=0;
  FOR i:=LENGTH(s0) DOWNTO 1 DO BEGIN
    IF (j MOD anz = 0) AND (j>0) THEN s1:='.'+s1;
    INC(j); s1:=s0[i]+s1;
  END;
  StrLong:=s1;
END;

PROCEDURE Datei_Namen(buffervon,bufferbis,start: LONGINT; mitTemp: BOOLEAN);
VAR d: LONGINT;
    fname: STRING;
BEGIN
   FOR d:=buffervon TO bufferbis DO BEGIN
      fname:=COPY(tempbest,1,8)+'.'+STR0(d-buffervon+start+temperst-1,3);
      IF mitTEMP AND (tempverz<>'') THEN BEGIN
         (* nur bei max. /B15 und TEMP-Variable gefllt *)
         IF fname[2]=':' THEN BEGIN
            IF fname[3]='\'
               THEN fname:=COPY(fname,4,255)
               ELSE fname:=COPY(fname,3,255);
         END;
         fname:=tempverz+'\'+fname;
      END;
      ASSIGN(datei[d].name,fname);
   END;
END;

FUNCTION Zahl_Erlaubt(von,bis: LONGINT; VAR zahl,hundert,zehn,eins: LONGINT):BOOLEAN;
BEGIN
   zahl:=bis-von+1;
   hundert:=zahl DIV 100;
   zehn:=(zahl MOD 100) DIV 10;
   eins:=zahl MOD 10;
   IF (von<1) OR (von>999) OR
      (bis<1) OR (bis>999) OR (von>bis) OR
      (zahl<1) OR (zahl>999) OR (bis+temperst-1>999)
      THEN zahl_erlaubt:=FALSE
      ELSE zahl_erlaubt:=TRUE;
END;

PROCEDURE INCRSTRING(VAR fname: STRING16; von,bis: STRING16);
VAR fzahl,d0,d1,p1: LONGINT;
    cc: STRING16; k:INTEGER;
BEGIN
   p1:=POS('.',fname);
   VAL(COPY(fname,p1+1,3),fzahl,k);
   IF k=0 THEN fname:=COPY(fname,1,p1)+STR0(fzahl+1,3)
   ELSE BEGIN
      FOR d0:=1 TO 3 DO BEGIN
         IF COPY(von,p1+d0,1)<>COPY(bis,p1+d0,1) THEN k:=d0;
      END;
      cc:=COPY(fname,p1+k,1);
      FOR d1:=8 DOWNTO 0 DO BEGIN
         IF cc=feld[d1] THEN cc:=feld[d1+1];
      END;
      fname:=COPY(fname,1,p1+k-1)+cc+COPY(fname,p1+k+1,3-k);
   END;
END;

PROCEDURE HeapMeldung(URSACHE:BYTE);
BEGIN
   WriteLN; WriteLN(' Speicherprobleme!!!'); WriteLN;
   CASE URSACHE OF
    0: {$IFDEF DOS}
       WriteLN(' MEMAVAIL zu gering (16bit) : ',MEMAVAIL);
       {$ELSE} ; {$ENDIF}
    1: WriteLN(' NEW-Anforderung ergibt NIL');
    2: WriteLN(' STRNEW-Anforderung ergibt NIL');
   END;
   {$IFNDEF DOS}
   HeapStatusFPC:=GetFPCHeapStatus;
   WriteLN(' Heap  Gre: ',StrLong(HeapStatusFPC.CurrHeapSize,3),
           '  Benutzt: ',StrLong(HeapStatusFPC.CurrHeapUsed,3),
           '  Frei: ',StrLong(HeapStatusFPC.CurrHeapFree,3));
   {$ENDIF}
   WriteLN; WriteLN(' Versuche krzere Satzlnge oder',
                    ' mehr (bzw. kleinere) Pufferspeicher');
   PARAMETER('?');
END;

PROCEDURE EING(VAR datei: TEXT; VAR anker: ZEIGER; maximal:LONGINT);
VAR akt,temp: ZEIGER;
    str0: STRING;
    pch0: ARRAY[0..255] OF CHAR;
    anzahl: LONGINT;
BEGIN
   {$IFDEF DOS}
   MARK(heap);
   {$ENDIF}
   anker:=NIL; temp:=NIL; anzahl:=1;
   WHILE (NOT EOF(datei)) AND (anzahl<=maximal) DO BEGIN
      {$IFDEF DOS}
      IF MEMAVAIL < 500 THEN HeapMeldung(0);
      {$ENDIF}
      NEW(akt);
      {$IFNDEF DOS}
      IF akt=NIL THEN HeapMeldung(1);
      {$ENDIF}
      ReadLn(datei,str0); str0:=COPY(str0,1,keylang); INC(anzahl);
      IF str0<>''
         THEN BEGIN
            STRPCOPY(pch0,str0); akt^.key:=STRNEW(pch0);
            {$IFNDEF DOS}
            IF akt^.key=NIL THEN HeapMeldung(2);
            {$ENDIF}
         END
         ELSE akt^.key:=CHR(0);
      IF anker=NIL THEN anker:=akt ELSE temp^.link:=akt;
      temp:=akt;
   END;
   IF anker<>NIL THEN akt^.link:=NIL;
END;

PROCEDURE AUSG(VAR datei: TEXT; VAR anker: ZEIGER);
VAR hilfe:ZEIGER;
BEGIN
   hilfe:=anker;
   WHILE hilfe<>NIL DO BEGIN
      WriteLN(datei,STRPAS(hilfe^.key));
      hilfe:=hilfe^.link;
   END;
   {$IFDEF DOS}
   RELEASE(heap);
   {$ELSE}
   WHILE anker<>NIL DO BEGIN
      hilfe:=anker; anker:=anker^.link;
      IF LENGTH(STRPAS(hilfe^.key))>0 THEN Dispose(hilfe^.key);
      Dispose(hilfe);
   END;
   {$ENDIF}
END;

PROCEDURE VERTEILE(VAR datei0: TEXT; buffer: LONGINT);
VAR d,anzahl: LONGINT;
BEGIN
   d:=1; anzahl:=1;
   REPEAT
      ReadLN(datei0,zeile0); WriteLN(datei[d].name,zeile0); INC(anzahl);
      IF d = buffer THEN d:=1 ELSE INC(d);
   UNTIL EOF(datei0) OR (anzahl>zeilenmax);
END;

FUNCTION MERGE(buffer: LONGINT):STRING;
VAR pch0,pch: ARRAY[0..255] OF CHAR;
    d0,d1: LONGINT;
BEGIN
   d0:=1; WHILE (d0<=buffer) AND NOT datei[d0].io DO INC(d0);
   zeile0:=datei[d0].zeile; d1:=1;
   FOR d0:=1 TO buffer DO BEGIN
      STRPCOPY(pch0,zeile0); STRPCOPY(pch,datei[d0].zeile);
      IF datei[d0].io AND VERGLEICH(pch,pch0) THEN BEGIN
         d1:=d0; zeile0:=datei[d0].zeile;
      END;
   END;
   MERGE:=datei[d1].zeile;
   READDATEI(d1);
END;

PROCEDURE LESE_DYN(VAR buffermax: LONGINT);
VAR str0: STRING; EOF2:BOOLEAN;
    anzahl: LONGINT;
BEGIN
   anzahl:=1;
   Datei_Namen(1,1,buffermax,FALSE);
   IF einok THEN EOF2:=EOF(eindatei) ELSE EOF2:=EOF(input);
   IF NOT EOF2 THEN REWRITE(datei[1].name);
   WHILE NOT EOF2 DO BEGIN;
      IF einok THEN ReadLN(eindatei,str0) ELSE ReadLN(input,str0);
      IF einok THEN EOF2:=EOF(eindatei) ELSE EOF2:=EOF(input);
      INC(anzahl); IF anzahl>zeilenmax THEN EOF2:=TRUE;
      WriteLN(datei[1].name,str0);
      IF (NOT EOF2) AND ((anzahl-1) MOD dynlaenge = 0) AND (buffermax<999)
      THEN BEGIN
         CLOSE(datei[1].name); INC(buffermax);
         Datei_Namen(1,1,buffermax,FALSE);
         REWRITE(datei[1].name);
      END;
   END;
   CLOSE(datei[1].name);
END;

PROCEDURE MISCH_TOPF(anzahl: LONGINT; von,bis,name: STRING16);
VAR d: LONGINT;
    fname: STRING16;
BEGIN
   IF POS('.',name)=LENGTH(name)-2 THEN name:=name+feld[0];
   fname:=von;
   FOR d:=1 TO anzahl DO BEGIN
      ASSIGN(datei[d].name,fname); RESET(datei[d].name);
      READDATEI(d); INCRSTRING(fname,von,bis);
   END;
   IF COPY(name,LENGTH(name)-3,4)='.000' THEN BEGIN
      REPEAT
         WriteLN(MERGE(anzahl));
      UNTIL All_EOF(anzahl);
   END
   ELSE BEGIN
      ASSIGN(datei[anzahl+1].name,name);
      REWRITE(datei[anzahl+1].name);
      REPEAT
         WriteLN(datei[anzahl+1].name,MERGE(anzahl));
      UNTIL All_EOF(anzahl);
      CLOSE(datei[anzahl+1].name);
   END;
   FOR d:=1 TO anzahl DO BEGIN
      CLOSE(datei[d].name); IF temploes THEN ERASE(datei[d].name);
   END;
END;

PROCEDURE MISCHEN(name: STRING16; von,bis: LONGINT);
VAR zahl,z100,z10,z1: LONGINT;
    ii,von_neu,bis_neu: LONGINT;
    name0: STRING16;
BEGIN
   IF NOT Zahl_Erlaubt(von,bis,zahl,z100,z10,z1) THEN EXIT;

   IF zahl = 100 THEN BEGIN
      FOR ii:=0 TO 9 DO BEGIN
         von_neu:=von+ii*10;
         bis_neu:=von_neu+9;
         MISCHEN(name+feld[ii],von_neu,bis_neu);
      END;
      MISCH_TOPF(10,name+feld[0],name+feld[9],name+'0');
      EXIT;
   END ELSE

   IF zahl > 100 THEN BEGIN;
      FOR ii:=0 TO z100 DO BEGIN
         von_neu:=von+ii*100;
         IF ii=z100
           THEN bis_neu:=von_neu+z10*10+z1-1
           ELSE bis_neu:=von_neu+99;
         MISCHEN(name+feld[ii],von_neu,bis_neu);
      END;
      name0:=name+feld[z100];
      IF (zahl MOD 100) > 0 THEN
         IF z1=0
            THEN MISCH_TOPF(z10,name0+feld[0],name0+feld[z10-1],name0+'0')
            ELSE MISCH_TOPF(z10+1,name0+feld[0],name0+feld[z10],name0+'0');
      EXIT;
   END ELSE

   IF zahl > 10 THEN BEGIN;
      FOR ii:=0 TO z10 DO BEGIN
         von_neu:=von+ii*10;
         IF ii=z10
            THEN bis_neu:=von_neu+z1-1
            ELSE bis_neu:=von_neu+9;
         MISCHEN(name+feld[ii],von_neu,bis_neu);
      END;
      EXIT;
   END ELSE

   MISCH_TOPF(bis-von+1,COPY(name,1,POS('.',name))+str0(von+temperst-1,3),
              COPY(name,1,POS('.',name))+str0(bis+temperst-1,3),name);

END;

PROCEDURE MISCHE_1699(name: STRING16; von,bis: LONGINT);
VAR zahl,z100,z10,z1: LONGINT;
    name0: STRING16;
BEGIN
   IF NOT Zahl_Erlaubt(von,bis,zahl,z100,z10,z1) THEN EXIT;
   name:=name+'0';
   IF bis-von<100 THEN name:=name+'0';
   IF bis-von<10 THEN name:=name+'0';

   MISCHEN(name,von,bis);

   name0:=name+feld[0];
   IF zahl > 100 THEN
      IF zahl MOD 100 = 0
         THEN MISCH_TOPF(z100,name0+'0',name+feld[z100-1]+'0',name+'00')
         ELSE MISCH_TOPF(z100+1,name0+'0',name+feld[z100]+'0',name+'00')
   ELSE

   IF (zahl > 10) AND (zahl <> 100) THEN
      IF zahl MOD 10 = 0
         THEN MISCH_TOPF(z10,name0,name+feld[z10-1],name+'0')
         ELSE MISCH_TOPF(z10+1,name0,name+feld[z10],name+'0')
END;

PROCEDURE TEILE_1699(buffer: LONGINT);
VAR str0: STRING; EOF2:BOOLEAN;
    norm,kk_add,jj_ext,zz_n,zz_sum,anzahl: LONGINT;
BEGIN
   zz_sum:=0;
   IF einok THEN BEGIN
      IF ZAEHLEN THEN BEGIN
         WHILE (NOT EOF(eindatei)) AND (zz_sum<zeilenmax) DO BEGIN;
            ReadLN(eindatei,str0); INC(zz_sum);
         END;
         CLOSE(eindatei); RESET(eindatei);
      END
      ELSE zz_sum:=zeilenmax;
   END
   ELSE BEGIN
      Datei_Namen(1,1,-temperst+1,FALSE);
      IF ZAEHLEN THEN BEGIN
         REWRITE(datei[1].name);
         WHILE (NOT EOF(input)) AND (zz_sum<zeilenmax) DO BEGIN;
            ReadLN(str0); WriteLN(datei[1].name,str0); INC(zz_sum);
         END;
         CLOSE(datei[1].name); RESET(datei[1].name);
      END
      ELSE zz_sum:=zeilenmax;
   END;
   Datei_Namen(2,2,1,FALSE); REWRITE(datei[2].name);
   IF zz_sum < buffermax THEN buffermax:=zz_sum;
   IF zz_sum > buffermax
      THEN norm:=zz_sum DIV buffermax
      ELSE norm:=1;
   kk_add:=zz_sum MOD buffermax;
   jj_ext:=1; zz_n:=0; anzahl:=1;
   IF einok THEN EOF2:=EOF(eindatei)
   ELSE
      IF ZAEHLEN THEN EOF2:=EOF(datei[1].name) ELSE EOF2:=EOF;
   WHILE (NOT EOF2) AND (jj_ext<=buffermax) AND (anzahl<=zeilenmax) DO BEGIN;
      INC(zz_n);
      IF ((zz_n > norm+1) AND (jj_ext <= kk_add) OR
          (zz_n > norm)   AND (jj_ext >  kk_add))
         THEN BEGIN
            zz_n:=1;
            INC(jj_ext); IF jj_ext>buffermax THEN jj_ext:=1;
            CLOSE(datei[2].name);
            Datei_Namen(2,2,jj_ext,FALSE);
            REWRITE(datei[2].name);
         END;
      IF einok THEN BEGIN ReadLN(eindatei,str0); EOF2:=EOF(eindatei); END
      ELSE
         IF ZAEHLEN
            THEN BEGIN ReadLN(datei[1].name,str0); EOF2:=EOF(datei[1].name); END
            ELSE BEGIN ReadLN(str0); EOF2:=EOF; END;
      WriteLN(datei[2].name,str0); INC(anzahl);
   END;
   CLOSE(datei[2].name);
   IF einok THEN CLOSE(eindatei)
   ELSE
      IF ZAEHLEN THEN BEGIN
         CLOSE(datei[1].name); ERASE(datei[1].name);
      END;
END;

PROCEDURE SORT_15(buffer: LONGINT);
VAR d: LONGINT;
BEGIN
   Datei_Namen(1,buffer,1,TRUE);
   IF FUNK_ERLAUBT(funktion,TEILE) AND NOT bufferdyn THEN BEGIN;
      FOR d:=1 TO buffer DO REWRITE(datei[d].name);
      IF einok
         THEN VERTEILE(eindatei,buffer)
         ELSE VERTEILE(input,buffer);
      FOR d:=1 TO buffer DO CLOSE(datei[d].name);
   END;
   buffer:=buffermax;
   IF FUNK_ERLAUBT(funktion,SORTIERE) THEN BEGIN;
      FOR d:=1 TO buffer DO BEGIN
         RESET(datei[d].name);
         EING(datei[d].name,anker,maxlongint);
         QUICK(anker);
         CLOSE(datei[d].name); REWRITE(datei[d].name);
         AUSG(datei[d].name,anker);
         CLOSE(datei[d].name);
      END;
   END;
   buffer:=buffermax;
   IF FUNK_ERLAUBT(funktion,MISCHE) THEN BEGIN;
      FOR d:=1 TO buffer DO BEGIN
         RESET(datei[d].name); READDATEI(d);
      END;
      REPEAT
         WriteLN(MERGE(buffer));
      UNTIL All_EOF(buffer);
      FOR d:=1 TO buffer DO BEGIN
         CLOSE(datei[d].name); IF temploes THEN ERASE(datei[d].name);
      END;
   END;
END;

PROCEDURE SORT_1699(buffer: LONGINT);
VAR d: LONGINT;
BEGIN
   IF FUNK_ERLAUBT(funktion,TEILE) AND NOT bufferdyn THEN BEGIN;
      TEILE_1699(buffer);
   END;
   buffer:=buffermax;
   IF FUNK_ERLAUBT(funktion,SORTIERE) THEN BEGIN;
      (* probieren mal umgekehrt, damit ggf. der letzte Topf
         zuerst abbricht, wenn er bei /D zu gro ist        *)
      FOR d:=buffer DOWNTO 1 DO BEGIN
         Datei_Namen(1,1,d,FALSE); RESET(datei[1].name);
         EING(datei[1].name,anker,maxlongint);
         QUICK(anker);
         CLOSE(datei[1].name); REWRITE(datei[1].name);
         AUSG(datei[1].name,anker);
         CLOSE(datei[1].name);
      END;
   END;
   buffer:=buffermax;
   IF FUNK_ERLAUBT(funktion,MISCHE) THEN BEGIN;
      MISCHE_1699(tempbest+'.',1,buffer);
   END;
END;

PROCEDURE NUR_ZAEHLEN;
BEGIN
   zeilenzahl:=0;
   IF einok
      THEN BEGIN
         WHILE (NOT EOF(eindatei)) AND (zeilenzahl<zeilenmax) DO BEGIN
            ReadLN(eindatei,zeile0); INC(zeilenzahl);
         END;
      END
      ELSE BEGIN
         WHILE (NOT EOF) AND (zeilenzahl<zeilenmax) DO BEGIN
            ReadLN(zeile0); INC(zeilenzahl);
         END;
      END;
   WriteLN('Anzahl:',zeilenzahl);
END;

PROCEDURE EINDATEI_OPEN;
BEGIN
   IF einname='' THEN einok:=FALSE
   ELSE BEGIN
      Assign(eindatei,einname);
      {$I-}Reset(eindatei);{$I+}
      IF IOResult=0 THEN einok:=TRUE ELSE einok:=FALSE;
   END;
END;

BEGIN
   {$IFNDEF DOS}
   ReturnNilIfGrowHeapFails:=TRUE;
   {$ENDIF}
   PARAMETER(PARAMSTR(1));
   EINDATEI_OPEN;
   IF funktion=0 THEN NUR_ZAEHLEN
   ELSE BEGIN
      IF bufferdyn THEN LESE_DYN(buffermax);
      CASE buffermax OF
       0:       BEGIN
                   IF einok
                      THEN EING(eindatei,anker,zeilenmax)
                      ELSE EING(input,anker,zeilenmax);
                   QUICK(anker);
                   AUSG(output,anker);
                END;
       1..15:   SORT_15(buffermax);
       16..999: SORT_1699(buffermax);
      END;
   END;
END (* QSort *).
