UNIT Fenster;  (* (c) ALFWARE Bernd Schubert 12/2010    *)
               (* Version fr XP-16bit Turbo Pascal     *)
               (* originale Version mit MEMW und inline *)
INTERFACE

USES  CRT, DOS, Monitor, Maus;

CONST SCREENSEG:WORD = $B800;

(*       Vordergrund &         nur
         Hintergrund           Vordergrund

         Black      0          Dark Gray      8
         Blue       1          Light Blue     9
         Green      2          Light Green   10
         Cyan       3          Light Cyan    11
         Red        4          Light Red     12
         Magenta    5          Light Magenta 13
         Brown      6          Yellow        14
         Light Gray 7          White         15

         Menue-art         Hintergrund         Balken
           (0)              15 on 0            4 on 7
            2               15 on 1            4 on 7
            1               15 on 6            8 on 2
            3               15 on 5            0 on 3
            4                0 on 7            4 on 2
            5                0 on 3           15 on 6    *)

TYPE ZEIGER_MENUE = ^MENUE_Z_TYPE;
     MENUE_Z_TYPE = RECORD
          Menue_Zeile: STRING;
          bag: STRING;
          next: ZEIGER_MENUE;
     END;
     MENUE_FELD = RECORD
          Menue_Anker: ZEIGER_MENUE;
          anzahl,maxlaenge: BYTE;
     END;

PROCEDURE OpenWindow(x1,y1,x2,y2,cx,cy,tbg,tc,framestyle:BYTE;
                       textoben,textunten:STRING; format:BYTE);
(* erffnet ein Fenster
   x1,y1     Anfangskoordinaten
   x2,y2     Endkoordinaten            (einer Diagonale)
   cx,cy     Anfangsposition des Cursors im Fenster (relative Angabe !)
   tbg,tc    Hintergrund und Vordergrundfarbe
   textoben  wird zentriert !
   textunten wird ab Position format ausgerichtet !   *)

FUNCTION CloseWindow:BOOLEAN;
(* schliet das aktuelle Fenster und liefert zurck ob das mglich war *)

PROCEDURE Farbe(art:BYTE; VAR b_f,b_bg,m_f,m_bg:BYTE);
(* liefert die Menue-Paletten *)

FUNCTION Auswahl_Menue(art,xh,yh:BYTE; Akt_Menue:MENUE_FELD; Titel:STRING;
                       standard:BYTE; oeffnen,loeschen,ESC_A:BOOLEAN):BYTE;
(* erffnet ein Menuefenster ab xh,yh in Abhngigkeit der lngsten Einzel-
   zeile von Akt_Menue und mit der berschrift Titel, falls oeffnen =TRUE
   whlt eine Alternative entsprechend Akt_MENUE durch die angegebenen
   Tasten bzw. durch Cursor
   Menue steht am Anfang auf standard
   Abbruch durch ESC mglich, falls ESC_A = TRUE
   loeschen gibt an, ob das Menue nach Auswahl verschwinden soll oder nicht
   art whlt eine der vorgegebenen Menuepaletten 1..5 oder sonst. 0  *)

FUNCTION Auswahl_Menue2(art,xh,yh:BYTE; Akt_Menue:MENUE_FELD; Titel:STRING;
                       standard:BYTE; oeffnen,loeschen,ESC_A:BOOLEAN):BYTE;
(* arbeitet wie Auswahl_Menue, aber auch mit Maus (sofern vorhanden) ! *)

FUNCTION Auswahl_Leiste(zeile,art:BYTE; Akt_Menue:MENUE_FELD; Titel:STRING;
                        standard:BYTE; oeffnen,loeschen,ESC_A:BOOLEAN):BYTE;
(* erffnet eine Menueleiste mit der berschrift Titel, falls oeffnen =TRUE
   Zeilen: 3,[22]
   whlt eine Alternative entsprechend Akt_MENUE durch die angegebenen
   Tasten bzw. durch Cursor
   Menue steht am Anfang auf standard
   Abbruch durch ESC mglich, falls ESC_A = TRUE
   loeschen gibt an, ob das Menue nach Auswahl verschwinden soll oder nicht
   art whlt eine der vorgegebenen Menuepaletten 1..5 oder sonst. 0  *)

PROCEDURE Menue_Liste(VAR M_Anker:MENUE_FELD; Kette,aktbag:STRING);
(* erzeugt eine Zeile eines Menue-Feldes
   M_Anker  Menue-Feld
   Kette    erscheinender Kommentar
   aktbag   String enthlt alle die Zeichen, die diese Zeile whlen sollen
            (am besten in Kette gro schreiben oder anders kenntlich machen)
   Menue-Zeilen erscheinen in der Reihenfolge im Menue, wie sie durch diese
   Prozedur (einzeln nacheinander) erzeugt wurden.   *)

PROCEDURE Leer_Menue(VAR I_Menue:MENUE_FELD; b1:BOOLEAN);
(* lscht alle Zeilen eines Menue-Feldes; falls b1=TRUE *)

PROCEDURE Write_Background;
(* blaue Balken oben und unten, sonst CHR(178) in White... *)

VAR BW_BWS:BOOLEAN;
    colbg,colf:ARRAY[0..15] OF BYTE;

IMPLEMENTATION

CONST F_Anzahl:WORD=0;
      F_Switch:BOOLEAN=FALSE;

TYPE  Z_Inhalt=^BYTE;
      Z_Fenster=^Z_Fenster0;
      Z_Fenster0 = RECORD
        next:Z_Fenster;
        F_Inhalt:Z_Inhalt;
      END;

VAR   F_Wurzel,F_Lauf,F_Ende:Z_Fenster;
      Inhalt:Z_Inhalt;
      ok:BOOLEAN; b:BYTE;

FUNCTION BW_Hardware:BOOLEAN;
VAR reg:REGISTERS;
BEGIN
   INTR($11,reg);
   BW_Hardware:=((reg.ax shr 4) and $03)=3;
END {BW_Hardware};

PROCEDURE BW_Monitor;
VAR b:BYTE;
BEGIN
   SCREENSEG:=$B000; BW_BWS:=TRUE;
   FOR b:=1 TO 7 DO colf[b]:=10;
END {BW_Monitor};

PROCEDURE Farbe(art:BYTE; VAR b_f,b_bg,m_f,m_bg:BYTE);
BEGIN
   IF BW_BWS THEN BEGIN m_bg:=7; m_f:=0; b_bg:=0; b_f:=15; END
   ELSE
      CASE art OF
         1:  BEGIN m_bg:=6; m_f:=15; b_bg:=2; b_f:=8; END;
         2:  BEGIN m_bg:=1; m_f:=15; b_bg:=7; b_f:=4; END;
         3:  BEGIN m_bg:=5; m_f:=15; b_bg:=3; b_f:=0; END;
         4:  BEGIN m_bg:=7; m_f:=0;  b_bg:=2; b_f:=4; END;
         5:  BEGIN m_bg:=3; m_f:=0;  b_bg:=6; b_f:=15; END;
        ELSE BEGIN m_bg:=0; m_f:=15; b_bg:=7; b_f:=4; END;
      END
END; {Farbe}

PROCEDURE Write_Background;
VAR i:INTEGER;
BEGIN
   OpenWindow(1,1,80,25,1,2,1,15,0,'','',0);
   GotoXY(1,2); FOR i:=1 TO 1840 DO Write(#178);
END {Write_Background};

PROCEDURE OpenWindow(x1,y1,x2,y2,cx,cy,tbg,tc,framestyle:BYTE;
                     textoben,textunten:STRING; format:BYTE);
VAR ub:BYTE;
   PROCEDURE WriteXY(x,y,s:BYTE);
   BEGIN
      GotoXY(x,y); Write(CHR(s));
   END {WriteXY};
   PROCEDURE Open(x1,y1,x2,y2,cx,cy,tbg,tc,framestyle,format:BYTE;
                  textoben,textunten:STRING; neu:BOOLEAN);
   VAR breite,hoehe,y66,Ra,i,h1,h2,h3,h4,h5:BYTE;
       hl:LONGINT;
   BEGIN
      WINDOW(1,1,80,25); TEXTATTR:=colbg[tbg]*16+colf[tc];
      IF framestyle<>0 THEN BEGIN
         CASE framestyle OF
            1:  BEGIN Ra:=196; h1:=218; h2:=191; h3:=192; h4:=217; h5:=179; END;
            2:  BEGIN Ra:=205; h1:=201; h2:=187; h3:=200; h4:=188; h5:=186; END;
           ELSE BEGIN Ra:=framestyle; h1:=Ra; h2:=Ra; h3:=Ra; h4:=Ra; h5:=Ra; END
         END;
         breite:=x2-x1+1; hoehe:=y2-y1; y66:=0;
         IF breite>LENGTH(textoben) THEN y66:=(breite-LENGTH(textoben)) DIV 2;
         WriteXY(x1-1,y1-1,h1);
         FOR i:=1 TO y66 DO Write(CHR(Ra));
         DELETE(textoben,breite+1,100);  Write(textoben);
         FOR i:=1 TO y66 DO Write(CHR(Ra));
         IF WHEREX=x2 THEN Write(CHR(Ra)); Write(CHR(h2));
         WriteXY(x1-1,y2+1,h3);
         IF format>breite
            THEN FOR i:=2 TO breite DO Write(CHR(Ra))
            ELSE BEGIN
               FOR i:=2 TO format DO Write(CHR(Ra));
               DELETE(textunten,breite-format+2,100); Write(textunten);
               FOR i:=format+LENGTH(textunten) TO breite DO Write(CHR(Ra));
            END;
         IF WHEREX=x2 THEN WRITE(chr(Ra));
         hl:=y2*160+x2*2;
         MEM[ScreenSeg:hl]:=h4; MEM[ScreenSeg:hl+1]:=TEXTATTR;
         FOR i:=0 TO hoehe DO BEGIN
            WriteXY(x1-1,y1+i,h5); WriteXY(x2+1,y1+i,h5);
         END
      END;
      WINDOW(x1,y1,x2,y2); IF neu THEN ClrScr;
      GotoXY(cx,cy);
   END {Open};
   FUNCTION SaveScreen(x1,y1,x2,y2:BYTE):BOOLEAN;
   VAR segment,offset:WORD;
       x,y:BYTE;
   BEGIN
      savescreen:=TRUE;
      IF (MAXAVAIL<(4020)) AND (NOT F_Switch) THEN BEGIN
         inline($fb); { sti } EXIT
      END;
      IF F_Switch THEN Inhalt:=F_Wurzel^.F_Inhalt
      ELSE BEGIN
         NEW(F_Lauf);
         IF F_Anzahl=0
            THEN F_Wurzel:=F_Lauf
            ELSE F_Ende^.next:=F_Lauf;
         F_Lauf^.next:=NIL; F_Ende:=F_Lauf; INC(F_Anzahl);
         GETMEM(inhalt,2*((x2-x1+1)*(y2-y1+1)+6));
         F_Ende^.F_Inhalt:=Inhalt;
      END;
      segment:=SEG(inhalt^); offset:=OFS(inhalt^);
      MEMW[segment:offset]:=WINDMIN;
      MEMW[segment:offset+2]:=WINDMAX;
      MEMW[segment:offset+4]:=WHEREY*256+WHEREX;
      MEMW[segment:offset+6]:=TEXTATTR;
      MEMW[segment:offset+8]:=y1*256+x1;
      MEMW[segment:offset+10]:=y2*256+x2;
      FOR y:=y1 TO y2 DO
         FOR x:=x1 TO x2 DO
            MEMW[segment:offset+12+2*(x-x1)+2*(y-y1)*(x2-x1+1)]:=
            MEMW[screenseg:2*(y-1)*80+2*(x-1)];
   END; {SaveScreen}
BEGIN {OpenWindow}
  inline($fa); { cli }
  IF framestyle=0 THEN ub:=0 ELSE ub:=1;
  IF SaveScreen(x1-ub,y1-ub,x2+ub,y2+ub)
     THEN Open(x1,y1,x2,y2,cx,cy,tbg,tc,framestyle,format,textoben,textunten,TRUE);
  inline($fb); { sti }
END;  {OpenWindow}

FUNCTION CloseWindow:BOOLEAN;
VAR  temp,segment,offset:WORD;
     x1,y1,x2,y2,x,y:BYTE;
BEGIN
   inline($fa); { cli }
   CloseWindow:=FALSE;
   IF F_Anzahl<=0 THEN BEGIN
      inline($fb); { sti } EXIT
   END;
   Closewindow:=TRUE;
   IF F_Switch
      THEN Inhalt:=F_Wurzel^.F_Inhalt
      ELSE Inhalt:=F_Ende^.F_Inhalt;
   segment:=SEG(inhalt^); offset:=OFS(inhalt^);
   WINDMIN:=MEMW[segment:offset];
   WINDMAX:=MEMW[segment:offset+2];
   temp:=MEMW[segment:offset+4];  GotoXY(LO(temp),HI(temp));
   TEXTATTR:=MEMW[segment:offset+6];
   temp:=MEMW[segment:offset+8];  x1:=LO(temp); y1:=HI(temp);
   temp:=MEMW[segment:offset+10]; x2:=LO(temp); y2:=HI(temp);
   FOR y:=y1 TO y2 DO
      FOR x:=x1 TO x2 DO
         MEMW[ScreenSeg:2*(y-1)*80+2*(x-1)]:=
         MEMW[segment:offset+12+2*(x-x1)+2*(y-y1)*(x2-x1+1)];
   IF NOT F_Switch THEN BEGIN
      FREEMEM(Inhalt,2*((x2-x1+1)*(y2-y1+1)+6));
      IF F_Anzahl=1 THEN DISPOSE(F_Wurzel)
      ELSE BEGIN
         F_Lauf:=F_Wurzel;
         WHILE NOT(F_Lauf^.next^.next=NIL) DO
            F_Lauf:=F_Lauf^.next;
            DISPOSE(F_Lauf^.next);
            F_Lauf^.next:=NIL; F_Ende:=F_Lauf;
       END;
       DEC(F_Anzahl);
   END;
   inline($fb);   { sti }
END;     {CloseWindow}

PROCEDURE Leer_Menue(VAR I_Menue:MENUE_FELD; b1:BOOLEAN);
VAR temp:ZEIGER_MENUE;
BEGIN
   WITH I_Menue DO BEGIN
      WHILE b1 AND (Menue_Anker<>NIL) DO BEGIN
         temp:=Menue_Anker; Menue_Anker:=Menue_anker^.next;
         DISPOSE(temp)
      END;
     Menue_Anker:=NIL; I_Menue.anzahl:=0;
   END
END {Leer_Menue};

FUNCTION Auswahl_Intern(modus,art,xh,yh:BYTE; Akt_Menue:MENUE_FELD; Titel:STRING;
                        standard:BYTE; oeffnen,loeschen,ESC_A:BOOLEAN):BYTE;
VAR wahl,i,b_bg,b_f,m_bg,m_f,posx,diffx:BYTE;
    anker,zeiger:ZEIGER_MENUE;
    temp,ESC_string:STRING;
    ch:CHAR;
    ml,mm,mr:BOOLEAN;
    xj,yj,ss,mx,my:INTEGER;
    FUNCTION Zentrum(s:STRING; n:BYTE):STRING;
    VAR z,temp:STRING; i:INTEGER;
    BEGIN
       temp:=''; z:=COPY(s,2,length(s)-2);
       CASE n OF
          0: Zentrum:='';
          1: Zentrum:=' ';
          2: Zentrum:='  ';
        ELSE BEGIN
           IF n<=LENGTH(z)+2 THEN temp:=COPY(z,1,n-2)
           ELSE BEGIN
              FOR i:=1 TO (n-2-length(z)) DIV 2 DO temp:=temp+' ';
              temp:=temp+z;  FOR i:=length(temp)+1 TO n-2 DO temp:=temp+' ';
           END;
           Zentrum:=' '+temp (* ? *)
       END END
    END {Zentrum};
BEGIN
   (* modus=0 ... normal Auswahlmenue
      modus=1 ...        Auswahlmenue2 Maus
      modus=2 ...        Auswahlleiste              *)
   Farbe(art,b_f,b_bg,m_f,m_bg);
   IF modus=1 THEN Maus_Mode(15,b_f+16,b_bg);
   IF ESC_A THEN ESC_string:='(Abbruch mit ESC)' ELSE ESC_string:='';
   IF Titel<>'' THEN Titel:=' '+Titel+' ';
   WITH Akt_Menue DO BEGIN
      IF modus=2 THEN BEGIN
         posx:=(72 DIV anzahl); diffx:=((72 MOD anzahl) DIV 2);
      END;
      IF oeffnen
         THEN
            IF modus<2
               THEN OpenWindow(xh+1,yh+1,xh+maxlaenge+2,yh+anzahl+2,
                               1,1,m_bg,m_f,2,Titel,ESC_string,2)
               ELSE OpenWindow(4+diffx,xh,77-diffx,xh,1,1,
                               m_bg,m_f,1,Titel,ESC_string,2)
         ELSE BEGIN
            IF modus<2
               THEN WINDOW(xh+1,yh+1,xh+maxlaenge+2,yh+anzahl+2)
               ELSE WINDOW(4+diffx,xh,77-diffx,xh);
            TEXTATTR:=colbg[m_bg]*16+colf[m_f]; ClrScr;
      END;
      zeiger:=Menue_Anker;
      FOR i:=1 TO anzahl DO BEGIN
         IF modus<2
            THEN GotoXY(2,i+1)
            ELSE GotoXY(2+(i-1)*posx,1);
         IF modus<2
            THEN Write(zeiger^.Menue_Zeile)
            ELSE Write(Zentrum(zeiger^.Menue_Zeile,posx));
         zeiger:=zeiger^.next;
      END;
      wahl:=standard; SetCursor(NOCURSOR);
      REPEAT
         IF modus<2
            THEN OpenWindow(xh+1,yh+wahl+1,xh+maxlaenge+2,yh+wahl+1,
                            1,1,b_bg,b_f,0,'','',0)
            ELSE OpenWindow(5+(wahl-1)*posx+diffx,xh,4+wahl*posx+diffx,
                            xh,1,1,b_bg,b_f,0,'','',0);
         zeiger:=Menue_Anker;
         FOR i:=1 to wahl-1 DO zeiger:=zeiger^.next;
         IF modus<2
            THEN Write(' '+zeiger^.Menue_Zeile)
            ELSE BEGIN
               WINDOW(5+(wahl-1)*posx+diffx,xh,5+wahl*posx+diffx,xh);
               Write(Zentrum(zeiger^.Menue_Zeile,posx));
               WINDOW(5+(wahl-1)*posx+diffx,xh,4+wahl*posx+diffx,xh);
            END;
         IF modus<>1
            THEN BEGIN ss:=1; ok:=Taste(ch,FALSE); END
            ELSE BEGIN
               ss:=0;
               REPEAT
                  Maus_An;
                  REPEAT
                     ok:=Taste2(ch,FALSE); Maus_Posit(mx,my,ml,mm,mr);
                  UNTIL (ok OR (ch=ESCAPE)) OR (ml OR mr);
                  Maus_Aus;
                  IF (ml OR mr)
                     THEN BEGIN
                        DELAY(300); xj:=xh; yj:=yh;
                        IF ((my>=(yj+1)*8) AND (my<=(yj+anzahl)*8) AND
                            (mx>=(xj*8)) AND (mx<=(xj+maxlaenge+1)*8)) THEN BEGIN
                           ss:=1;
                           IF my=(yj+wahl)*8
                              THEN ch:=RETURN
                              ELSE BEGIN
                                 ch:=' '; wahl:=(my div 8)-yj; ss:=2;
                     END END END {THEN}
                     ELSE ss:=1;
               UNTIL ss>0;
            END;
         IF ss=1
            THEN
               CASE ch OF
               ENDKEY:    wahl:=anzahl;
               HOMEKEY:   wahl:= 1;
               UPKEY,
               LEFTKEY:   IF wahl=1
                             THEN wahl:=anzahl
                             ELSE wahl:=wahl-1;
               DOWNKEY,
               RIGHTKEY:  wahl:=(wahl MOD anzahl)+1;
               ESCAPE:    IF ESC_A
                             THEN wahl:=0
                             ELSE ch:=' ';
               ELSE BEGIN
                          zeiger:=Menue_Anker;
                          FOR i:=1 TO anzahl DO BEGIN
                             IF (POS(ch,zeiger^.bag)<>0)
                                THEN BEGIN ch:=ESCAPE; wahl:=i END;
                             zeiger:=zeiger^.next;
               END; END  END; {CASE}
         ok:=CloseWindow;
      UNTIL (ch IN [RETURN,ESCAPE]);
      IF ch<>ESCAPE THEN BEGIN
         TextColor(colf[b_f]); TextBackground(colbg[b_bg]);
         IF modus<2
            THEN WINDOW(xh+1,yh+wahl+1,xh+maxlaenge+2,yh+wahl+1)
            ELSE WINDOW(5+(wahl-1)*posx+diffx,xh,4+wahl*posx+diffx,xh);
         ClrScr; zeiger:=Menue_Anker;
         FOR i:=1 to wahl-1 DO zeiger:=zeiger^.next;
         IF modus<2
            THEN Write(' '+zeiger^.Menue_Zeile)
            ELSE Write(Zentrum(zeiger^.Menue_Zeile,posx));
         TextColor(colf[m_f]); TextBackground(colbg[m_bg]);
      END;
      IF loeschen THEN ok:=CloseWindow;  Setcursor(TPCURSOR);
      Auswahl_Intern:=wahl; IF modus=1 THEN Maus_aus;
END END;  {Auswahl_Intern}

FUNCTION Auswahl_Menue(art,xh,yh:BYTE; Akt_Menue:MENUE_FELD; Titel:STRING;
                       standard:BYTE; oeffnen,loeschen,ESC_A:BOOLEAN):BYTE;
BEGIN
   Auswahl_Menue:=Auswahl_Intern(0,art,xh,yh,Akt_Menue,Titel,
                                standard,oeffnen,loeschen,ESC_A);
END;  {Auswahl_Menue}

FUNCTION Auswahl_Menue2(art,xh,yh:BYTE; Akt_Menue:MENUE_FELD; Titel:STRING;
                       standard:BYTE; oeffnen,loeschen,ESC_A:BOOLEAN):BYTE;
VAR io:BOOLEAN; quali,modus:INTEGER;
BEGIN
   Maus_Driver(io,quali);
   IF io THEN modus:=1 ELSE modus:=0;
   Auswahl_Menue2:=Auswahl_Intern(modus,art,xh,yh,Akt_Menue,Titel,
                                  standard,oeffnen,loeschen,ESC_A);
END;  {Auswahl_Menue2}

FUNCTION Auswahl_Leiste(zeile,art:BYTE; Akt_Menue:MENUE_FELD; Titel:STRING;
                        standard:BYTE; oeffnen,loeschen,ESC_A:BOOLEAN):BYTE;
BEGIN
   IF NOT (zeile in [3,22]) THEN zeile:=22;
   Auswahl_Leiste:=Auswahl_Intern(2,art,zeile,0,Akt_Menue,Titel,
                                  standard,oeffnen,loeschen,ESC_A);
END;  {Auswahl_Leiste}

PROCEDURE Menue_Liste(VAR M_Anker:MENUE_FELD; Kette,aktbag:STRING);
VAR help,weiter:ZEIGER_MENUE;
    aktlaenge:BYTE;
BEGIN
  WITH M_Anker DO BEGIN
     NEW(help);  help^.next:=NIL;
     help^.Menue_Zeile:=' '+Kette+' ';  help^.bag:=aktbag;
     aktlaenge:=LENGTH(Kette)+2;
     IF (Menue_Anker=NIL) OR (anzahl=0)
        THEN BEGIN
           anzahl:=1; MENUE_ANKER:=help; maxlaenge:=aktlaenge
        END
        ELSE BEGIN
           anzahl:=anzahl+1;  weiter:=Menue_Anker;
           WHILE weiter^.next<>NIL DO weiter:=weiter^.next;
           weiter^.next:=help;
           IF aktlaenge>maxlaenge THEN maxlaenge:=aktlaenge;
        END
END END {Menue_Liste};

BEGIN
   BW_BWS:=FALSE; FOR b:=0 TO 15 DO BEGIN colf[b]:=b; colbg[b]:=b; END;
   IF BW_Hardware THEN BW_Monitor;
END (* Fenster *).
