{$IFDEF DOS} {$N+,V-} {$ENDIF}
UNIT Monitor;  (* (c) ALFWARE Bernd Schubert *)

{ $DEFINE Graphik}

INTERFACE

USES CRT, DOS {$IFDEF Graphik}, Graph, Gem {$ENDIF};

CONST
      LowerCase =   'abcdefghijklmnopqrstuvwxyz';
      UpperCase =   'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      Digits    =   '1234567890';
      Letters   =   LowerCase+UpperCase;
      Hex       =   Digits+'ABCDEFabcdef';
      alfabeta  =   [21,32..175,224..255];
      InsCursor =   $0707;      (* unterste Zeile *)
      BlkCursor =   $0007;      (* Blockcursor *)
      NoCursor  =   $1000;      (* unsichtbar *)
      TPCursor  =   $0607;      (* Turbo-Pascal Cursor *)

(* Keys and Codes... *)
      RETURN  =   #13;    ESCAPE   = #27;
      F1_KEY  =   #187;   F2_KEY   = #188;   F3_KEY    = #189;
      F4_KEY  =   #190;   F5_KEY   = #191;   F6_KEY    = #192;
      F7_KEY  =   #193;   F8_KEY   = #194;   F9_KEY    = #195;
      F10_KEY =   #196;   F11_KEY  = #197;   F12_KEY   = #198;
      LEFTKEY =   #203;   RIGHTKEY = #205;   DELETKEY  = #211;
      UPKEY   =   #200;   DOWNKEY  = #208;   BACKSPACE = #8;
      ENDKEY  =   #207;   INSKEY   = #210;   HOMEKEY   = #199;

VAR
     deftextattr: BYTE;            (* Textattribut fr Defaultwerte *)
     enable_ESC : BOOLEAN;         (* Abbruch durch ESC erlaubt *)
     enable_wi,
     enable_de  : BYTE;
     All_Char   : STRING;
     graphio    : BOOLEAN;         (* E/A im Graphik-Modus (sonst Text) *)

PROCEDURE SetPos(y,x:INTEGER);
(* das verstndliche GotoXY *)

PROCEDURE SetCursor(Cur:Word);
(* verndert Cursorformen *)

FUNCTION EditString(VAR S: STRING; CharBag: STRING; MaxLen: BYTE): BOOLEAN;
(* Funktion zum Editieren eines Strings (bzw des Defaultstrings) der
   maximal 'MaxLen' Zeichen umfassen und nur aus den in 'CharBag'
   enthaltenen Zeichen bestehen darf; falls 'CharBag' leer ist, sind
   alle Zeichen erlaubt; Wenn die Eingabe mit ESC abgebrochen wurde und
   die Variable enable_ESC = TRUE war, dann ist der Funktionswert = FALSE *)

FUNCTION Taste(VAR ch:CHAR; outp:BOOLEAN):BOOLEAN;
(* Funktion wartet auf Tastendruck; liefert FALSE, falls mit ESC abge-
   brochen wurde und enable_ESC = TRUE (sonst wird ESC nicht akzeptiert !);
   'ch' enthlt die eingegebene Taste, diese wird fr outp = TRUE auch auf
   den Bildschirm gegeben *)

FUNCTION Taste2(VAR ch:CHAR; outp:BOOLEAN):BOOLEAN;
(* funktioniert wie Taste, nur wird nicht gewartet !
   liefert auch FALSE, wenn keine Taste gedrckt war *)

FUNCTION Tasten_String(c:CHAR):STRING;
(* liefert einen druckbaren Namen fr alle Sondertasten *)

(* Die folgenden Funktionen sind Einlesefunktionen fr diverse Datentypen,
   sie liefern FALSE, falls die Eingabe mit ESC abgebrochen wurde (s.o.).
   Ist 'DEF' = TRUE, dann wird der Wert von 'RETVAL' dem Benutzer als
   Defaultwert angeboten.  Die Funktionen liefern nur dann TRUE, wenn
   der eingegebene Wert innerhalb der Bereichsgrenzen fr den jeweiligen
   Datentyp liegt *)

FUNCTION ReadShortInt(VAR RetVal:SHORTINT; Def:BOOLEAN):BOOLEAN;

FUNCTION ReadByte(VAR RetVal:BYTE; Def:BOOLEAN):BOOLEAN;

FUNCTION ReadInt(VAR RetVal:INTEGER; Def:BOOLEAN):BOOLEAN;

FUNCTION ReadWord(VAR RetVal:WORD; Def:BOOLEAN):BOOLEAN;

FUNCTION ReadLongInt(VAR RetVal:LONGINT; Def:BOOLEAN):BOOLEAN;

PROCEDURE ReadBool(VAR BoolVal:BOOLEAN);

FUNCTION ReadReal(VAR RetVal:REAL; Def:BOOLEAN):BOOLEAN;

(* ... und die zugehrigen Ausgabefunktionen *)

PROCEDURE WriteShortInt(OVAL:SHORTINT);

PROCEDURE WriteByte(OVAL:BYTE);

PROCEDURE WriteInt(OVAL:INTEGER);

PROCEDURE WriteWord(OVAL:WORD);

PROCEDURE WriteLongInt(OVAL:LONGINT);

PROCEDURE WriteReal(OVAL:REAL);

PROCEDURE WriteRealPunkt(OVAL:REAL);

PROCEDURE WriteBool(BVAL:BOOLEAN);

IMPLEMENTATION

VAR Typ, b : BYTE;
    ERGINT : LONGINT;      (* global fr alle INTEGER *)
    ERGREAL: REAL;         (* global fr REAL *)
    SameKey: CHAR;
    OS:      STRING;

PROCEDURE WriteGT(s:STRING);
BEGIN
   {$IFDEF Graphik} IF graphio THEN OutText(s) ELSE {$ENDIF}
   Write(s);
END (* WriteGT *);

PROCEDURE SetCursor(Cur:Word);
VAR regs: REGISTERS;
BEGIN
   WITH regs DO BEGIN
      AH:=1;
      BH:=0;
      CX:=Cur;
      INTR($10,regs)          (* Cursor setzen *)
END END (* SetCursor *);

PROCEDURE ChgCur(Ins:BOOLEAN);
BEGIN
   IF Ins
      THEN SetCursor(TPCursor)
      ELSE SetCursor(InsCursor);
END (* ChgCur *);

PROCEDURE SetPos(y,x:INTEGER);
BEGIN
   {$IFDEF graphik} IF graphio THEN MoveTo(x,y) ELSE {$ENDIF}
   GotoXY(x,y)
END (* SetPos *);

FUNCTION GetKey:CHAR;
VAR ch: CHAR;
BEGIN
   IF SameKey<>#0
      THEN BEGIN
         GetKey:=SameKey; SameKey:=#0
      END
      ELSE BEGIN
         ch:=READKEY;
         REPEAT
            IF ch=#0
               THEN BEGIN
                  ch:=READKEY;
                  IF ORD(ch)>127
                     THEN ch:=#0
                     ELSE GetKey:=CHR(ORD(ch)+128)
               END
               ELSE GetKey:=ch;
         UNTIL ch<>#0;
  END
END (* GetKey *);

FUNCTION EditString(VAR S: STRING; CharBag: STRING; MaxLen: BYTE): BOOLEAN;
VAR CurX,CurY,CurPos,
    SavedTextAttr{,i,MaxPos}: INTEGER;
    {InitPosX,InitPosY      : INTEGER;}
    ch                      : CHAR;
    ins                     : BOOLEAN;
    SLen                    : BYTE ABSOLUTE S;   (* erstes Byte von S *)
   {$IFDEF graphik} PROCEDURE OutKette(s:STRING);
   BEGIN OutText(s);
      Moveto(InitPosX+(CurPos-1)*BSBreite,GetY+2); OutText('_');
   END; {$ENDIF}
BEGIN
   {$IFDEF graphik} IF graphio
      THEN BEGIN
         CurX:=GetX; CurY:=GetY; {InitPosX:=CurX; InitPosY:=CurY;}
         MaxPos:=CurX+MaxLen*BSBreite;
      END
      ELSE BEGIN {$ENDIF}
         CurX:=WhereX;  CurY:=WhereY; {$IFDEF graphik}
      END;
   {$ENDIF}
   SameKey:=#0; IF SLen<MaxLen THEN CurPos:=SUCC(Slen)  ELSE CurPos:=Slen;
   {$IFDEF graphik} IF graphio
      THEN GraphLoeschen(CurX,CurY,MaxPos,CurY+BSHoehe*2)
      ELSE BEGIN {$ENDIF}
         ins:=TRUE; SetCursor(NOCursor); Write('':MaxLen); {$IFDEF graphik}
      END;
   {$ENDIF}
   IF CurPos>1 THEN BEGIN
      {$IFDEF graphik} IF graphio
         THEN BEGIN
            Moveto(CurX,CurY); OutKette(s);
            Moveto(CurX+(CurPos-1)*BSBreite,CurY);
         END
         ELSE BEGIN {$ENDIF}
            SavedTextAttr:=TextAttr; TextAttr:=DefTextAttr;
            Gotoxy(CurX,CurY); Write(S);  TextAttr:=SavedTextAttr;
            Gotoxy(CurX+CurPos-1,CurY); ChgCur(Ins); {$IFDEF graphik}
         END;
      {$ENDIF}
      ch:=GetKey;
      IF (POS(ch,CharBag)<>0) OR ((CharBag='') AND (POS(ch,All_Char)<>0))
         THEN BEGIN
            S[0]:=#1; S[1]:=ch; CurPos:=2;
         END
         ELSE SameKey:=ch;
   END;
   REPEAT
      {$IFDEF graphik} IF graphio
         THEN BEGIN
            GraphLoeschen(CurX,CurY,MaxPos,CurY+BSHoehe*2);
            Moveto(CurX,CurY); OutKette(s);
         END
         ELSE BEGIN {$ENDIF}
            SetCursor(NoCursor);  Gotoxy(CurX,CurY);  Write(S,'':(MaxLen-SLen));
            Gotoxy(CurX+CurPos-1,CurY); ChgCur(ins); {$IFDEF graphik}
         END;
      {$ENDIF}
      ch:=GetKey;
      CASE ch OF
      LEFTKEY:   IF CurPos>1 THEN DEC(CurPos);
      RIGHTKEY:  IF (CurPos<=SLen) AND (CurPos<MaxLen) THEN INC(CurPos);
      BACKSPACE: IF CurPos>1 THEN BEGIN
                    DEC(CurPos); Delete(S,CurPos,1)
                 END;
      UPKEY,
      DOWNKEY:   BEGIN
                    S:=''; CurPos:=1;
                 END;
      DELETKEY:  IF CurPos<=SLen THEN Delete(S,CurPos,1);
      HOMEKEY:   CurPos:=1;
      ENDKEY:    IF SLen<MaxLen
                    THEN CurPos:=SUCC(SLen)
                    ELSE CurPos:=Maxlen;
      INSKEY:    BEGIN
                    ins:=NOT ins;
                    IF NOT graphio THEN ChgCur(ins);
                 END;
      ELSE
                 IF (POS(ch,CharBag)<>0) OR
                    ((CharBag='') AND (POS(ch,All_Char)<>0))
                    THEN
                       IF ins
                          THEN
                             IF (SLen<MaxLen)
                                THEN BEGIN
                                   Insert(ch,S,CurPos);
                                   IF CurPos<MaxLen THEN INC(CurPos);
                                END
                                ELSE
                                   IF CurPos=MaxLen THEN S[CurPos]:=ch ELSE
                          ELSE BEGIN
                             S[CurPos]:=ch;
                             IF CurPos>SLen THEN INC(SLen);
                             IF CurPos<MaxLen THEN INC(CurPos)
                          END;
      END (* CASE *);
   UNTIL ((ch=ESCAPE) AND enable_ESC) OR (ch=RETURN);
   EditString:=(ch<>ESCAPE);
END (* EditString *);

FUNCTION EvalString(VAR S:STRING; CB:STRING; Len:BYTE):BOOLEAN;
VAR CurX,CurY: INTEGER;
    cd,i:      INTEGER;
    HelpS:     STRING;
    OK:        BOOLEAN;
BEGIN
   {$IFDEF graphik} IF graphio
       THEN BEGIN
          CurX:=GetX; CurY:=GetY;
       END
       ELSE BEGIN
          {$ENDIF} CurX:=WhereX; CurY:=WhereY; {$IFDEF graphik}
       END; {$ENDIF}
   REPEAT
      {$IFDEF graphik} IF graphio
         THEN Moveto(CurX,CurY)
         ELSE {$ENDIF} Gotoxy(CurX,CurY);
      HelpS:=S;
      IF NOT EditString(HelpS,CB,Len) THEN BEGIN
         EvalString:=FALSE; Exit
      END;
      IF typ<5
         THEN BEGIN
            VAL(HelpS,ERGINT,cd);
            CASE typ OF
             0: OK:=(-128<=ERGINT) AND (ERGINT<=127);     (* ShortInt *)
             1: OK:=(0<=ERGINT) AND (ERGINT<=255);        (* BYTE *)
             2: OK:=(-32678<=ERGINT) AND (ERGINT<=32767); (* Integer *)
             3: OK:=(0<=ERGINT) AND (ERGINT<=65535);      (* WORD *)
             4: OK:=TRUE;                                 (* LongInt *)
            END
         END
         ELSE BEGIN
            FOR i:=1 TO LENGTH(HelpS) DO BEGIN;
                IF HelpS[i]=',' THEN HelpS[i]:='.';
            END;
            VAL(HelpS,ERGREAL,cd); OK:=TRUE;
         END;
   UNTIL (cd=0) AND OK;
   S:=HelpS;   EvalString:=TRUE;
END (* EvalString *);

FUNCTION ReadShortInt(VAR RetVal:SHORTINT; Def:BOOLEAN):BOOLEAN;
VAR S: STRING[4];
BEGIN
   typ:=0;  IF Def THEN STR(RetVal,S) ELSE S:='';
   ReadShortInt:=EvalString(S,'$-'+Hex,4);
   RetVal:=SHORTINT(ERGINT);
END (* ReadShortInt *);

FUNCTION ReadByte(VAR RetVal:BYTE; Def:BOOLEAN):BOOLEAN;
VAR S: STRING[4];
BEGIN
   typ:=1;  IF Def THEN STR(RetVal,S) ELSE S:='';
   ReadByte:=EvalString(S,'$'+Hex,3);
   RetVal:=BYTE(ERGINT);
END (* ReadByte *);

FUNCTION ReadInt(VAR RetVal:INTEGER; Def:BOOLEAN):BOOLEAN;
VAR S: STRING[6];
BEGIN
   typ:=2;  IF Def THEN STR(RetVal,S) ELSE S:='';
   ReadInt:=EvalString(S,'$-'+Hex,6);
   RetVal:=INTEGER(ERGINT);
END (* ReadInt *);

FUNCTION ReadWord(VAR RetVal:WORD; Def:BOOLEAN):BOOLEAN;
VAR S: STRING[6];
BEGIN
   typ:=3;  IF Def THEN STR(RetVal,S) ELSE S:='';
   ReadWord:=EvalString(S,'$'+Hex,6);
   RetVal:=WORD(ERGINT);
END (* ReadWord *);

FUNCTION ReadLongInt(VAR RetVal:LONGINT; Def:BOOLEAN):BOOLEAN;
VAR S: STRING[12];
BEGIN
   typ:=4;  IF Def THEN STR(RetVal,S) ELSE S:='';
   ReadLongInt:=EvalString(S,'$-'+Hex,12);
   RetVal:=LONGINT(ERGINT);
END (* ReadLongInt *);

FUNCTION ReadReal(VAR RetVal:REAL; Def:BOOLEAN):BOOLEAN;
VAR S: STRING[17];
BEGIN
   typ:=5;
   IF Def
      THEN BEGIN
         IF enable_wi>0
            THEN
               IF enable_de>0
                  THEN STR(RetVal:enable_wi:enable_de,S)
                  ELSE STR(RetVal:enable_wi,S)
            ELSE STR(RetVal,S);
         IF S[1]=' ' THEN S:=Copy(S,2,16);
      END
      ELSE S:='';
   ReadReal:=EvalString(S,'+-eE,.'+Hex,17);
   RetVal:=ERGREAL;
END (* ReadReal *);

PROCEDURE ReadBool(VAR BoolVal:BOOLEAN);
VAR ch:CHAR;
BEGIN
   IF BoolVal
      THEN WriteGT('(J)/N ')
      ELSE WriteGT('(N)/J ');
   IF Taste(ch,TRUE) THEN
      CASE ch OF
        'y','Y','t','T','J','j' : BoolVal:=TRUE;
        'f','F','N','n'         : BoolVal:=FALSE;
        ELSE   ;
      END
END (* ReadBool *);

PROCEDURE WriteShortInt(OVAL:SHORTINT);
BEGIN
   STR(OVAL,OS); WriteGT(OS);
END (* WriteShortInt *);

PROCEDURE WriteByte(OVAL:BYTE);
BEGIN
   STR(OVAL,OS); WriteGT(OS);
END (* WriteByte *);

PROCEDURE WriteInt(OVAL:INTEGER);
BEGIN
   STR(OVAL,OS); WriteGT(OS);
END (* WriteInt *);

PROCEDURE WriteWord(OVAL:WORD);
BEGIN
   STR(OVAL,OS); WriteGT(OS);
END (* WriteWord *);

PROCEDURE WriteLongInt(OVAL:LONGINT);
BEGIN
   STR(OVAL,OS); WriteGT(OS);
END (* WriteLongInt *);

PROCEDURE WriteReal(OVAL:REAL);
BEGIN
   IF enable_wi>0
      THEN
         IF enable_de>0
            THEN STR(OVal:enable_wi:enable_de,OS)
            ELSE STR(OVal:enable_wi,OS)
      ELSE STR(OVAL,OS);
   IF OS[1]=' ' THEN OS:=Copy(OS,2,16);
   WriteGT(OS);
END (* WriteReal *);

PROCEDURE WriteRealPunkt(OVAL:REAL);
VAR i,j,k:INTEGER; OS2:STRING;
BEGIN
   IF enable_wi>0
      THEN
         IF enable_de>0
            THEN STR(OVal:enable_wi:enable_de,OS)
            ELSE STR(OVal:enable_wi,OS)
      ELSE STR(OVAL,OS);
   IF OS[1]=' ' THEN OS:=Copy(OS,2,16);
   k:=LENGTH(OS); OS2:='';
   IF enable_de>0 THEN BEGIN;
      k:=k-enable_de-1; OS2:=COPY(OS,k+1,enable_de+1);
   END;
   j:=0;
   FOR i:=k DOWNTO 1 DO BEGIN
      IF (j MOD 3 = 0) AND (j>0) THEN OS2:=' '+OS2;
      INC(j); OS2:=OS[i]+OS2;
   END;
   WriteGT(OS2);
END (* WriteRealPunkt *);

PROCEDURE WriteBool(BVAL:BOOLEAN);
BEGIN
   IF BVal
      THEN WriteGT('''TRUE''')
      ELSE WriteGT('''FALSE''');
END (* WriteBool *);

FUNCTION Taste(VAR ch:CHAR; outp:BOOLEAN):BOOLEAN;
BEGIN
   Taste:=TRUE; SameKey:=#0;
   IF enable_ESC
      THEN BEGIN
         ch:=GetKey;
         IF ch=ESCAPE THEN Taste:=FALSE
      END
      ELSE
         REPEAT ch:=GetKey UNTIL ch<>ESCAPE;
   IF (outp=TRUE) AND (POS(ch,All_Char)<>0) THEN WriteGT(ch);
END (* Taste *);

FUNCTION Taste2(VAR ch:CHAR; outp:BOOLEAN):BOOLEAN;
BEGIN
   ch:=' ';
   IF NOT KEYPRESSED
      THEN Taste2:=FALSE
      ELSE Taste2:=Taste(ch,outp);
END (* Taste2 *);

FUNCTION Tasten_String(c:CHAR):STRING;
BEGIN
   CASE c OF
    RETURN   : Tasten_String:='RETURN';
    ESCAPE   : Tasten_String:='ESCAPE';
    F1_KEY   : Tasten_String:='F1';
    F2_KEY   : Tasten_String:='F2';
    F3_KEY   : Tasten_String:='F3';
    F4_KEY   : Tasten_String:='F4';
    F5_KEY   : Tasten_String:='F5';
    F6_KEY   : Tasten_String:='F6';
    F7_KEY   : Tasten_String:='F7';
    F8_KEY   : Tasten_String:='F8';
    F9_KEY   : Tasten_String:='F9';
    F10_KEY  : Tasten_String:='F10';
    F11_KEY  : Tasten_String:='F11';
    F12_KEY  : Tasten_String:='F12';
    BACKSPACE: Tasten_String:='BS';
    DELETKEY : Tasten_String:='DEL';
    LEFTKEY  : Tasten_String:='<-';
    RIGHTKEY : Tasten_String:='->';
    UPKEY    : Tasten_String:='^';
    DOWNKEY  : Tasten_String:='v';
    ENDKEY   : Tasten_String:='END';
    INSKEY   : Tasten_String:='INSERT';
    HOMEKEY  : Tasten_String:='HOME';
    ELSE       Tasten_String:=c;
   END;
END (* Tasten_String *);

BEGIN
   All_Char:= '';
   FOR b:=1 TO 255 DO
      IF b IN alfabeta THEN All_Char:=All_Char+CHR(b);
   DefTextAttr:=textattr;
   enable_ESC:=TRUE;
   enable_wi:=10; (* 0??? *)
   enable_de:=2;  (* 0??? *)
   graphio:=FALSE;
END (* Monitor *).
