UNIT StdIO;      (* (c) ALFWARE Bernd Schubert *)

INTERFACE

{$IFNDEF DOS}
VAR KEYBOARD_AN:BOOLEAN;
(* wird FALSE vorbelegt *)
{$ENDIF}

FUNCTION Taste0:CHAR;
(* liest von der Tastatur, auch ohne CRT *)

FUNCTION UpString(s:STRING):STRING;
(* wandelt den gesamten String im Grobuchstaben *)

FUNCTION Str0(n,anz:INTEGER):STRING;
(* Integer fester Lnge (mit Vornullen) *)

FUNCTION StrLong(n,anz:LONGINT):STRING;
(* LongInt wird lesbarer mit . *)

FUNCTION Str0Long(n,anz:LONGINT):STRING;
(* LongInt fester Lnge (mit Vornullen) *)

FUNCTION StrLiLong(n,anz:LONGINT):STRING;
(* LongInt fester Lnge (linksbndig mit Nach-blanks) *)

FUNCTION StrReLong(n,anz:LONGINT):STRING;
(* LongInt fester Lnge (rechtsbndig mit Vor-blanks) *)


IMPLEMENTATION

{$IFDEF DOS}

USES DOS;

FUNCTION Taste0:CHAR;
VAR ch:CHAR;
    regs:REGISTERS;
BEGIN
   regs.AH:=$00; INTR($16,regs); ch:=CHR(regs.AL);
   Taste0:=ch;
END (* Taste0 *);

{$ELSE}

USES KeyBoard;

FUNCTION Taste0:CHAR;
VAR ch:CHAR;
    K:TKeyEvent;
BEGIN
   IF NOT KEYBOARD_AN THEN InitKeyboard;
   K:=GetKeyEvent;
   K:=TranslateKeyEvent(K);
   CASE GetKeyEventFlags(K) OF
   kbASCII : ch:=GetKeyEventChar(K);
   (* ESC, ENTER, BACKSPACE kommen als ASCII an *)
   kbFnKey :
      CASE GetKeyEventCode(K) OF
      65313 : ch:=CHR(200); (* up     *)
      65319 : ch:=CHR(208); (* down   *)
      65315 : ch:=CHR(203); (* left   *)
      65317 : ch:=CHR(205); (* right  *)
      65312 : ch:=CHR(199); (* pos1   *)
      65318 : ch:=CHR(207); (* end    *)
      65321 : ch:=CHR(210); (* insert *)
      65322 : ch:=CHR(211); (* delete *)
      65281..65292:         (* Funktionstasten *)
              ch:=CHR(GetKeyEventCode(K)-65094);
     ELSE ;
     END;
   ELSE ;
   END;
   IF NOT KEYBOARD_AN THEN DoneKeyboard;
   Taste0:=ch;
END (* Taste0 *);

{$ENDIF}

FUNCTION UpString(s:STRING):STRING;
VAR t:STRING;
BEGIN
   t:='';
   WHILE s<>'' DO BEGIN t:=t+UPCASE(s[1]); s:=COPY(s,2,LENGTH(s)-1); END;
   UpString:=t;
END; (* Upstring *)

FUNCTION Str0(n,anz:INTEGER):STRING;
VAR s0,s1:STRING; i:INTEGER;
BEGIN
   STR(n,s0); s1:='';
   FOR i:=anz-LENGTH(s0) DOWNTO 1 DO s1:=s1+'0';
   Str0:=s1+s0;
END (* Str0 *);

FUNCTION StrLong(n,anz:LONGINT):STRING;
VAR s0,s1:STRING; i,j:INTEGER;
BEGIN
   STR(n,s0); s1:=''; j:=0;
   FOR i:=LENGTH(s0) DOWNTO 1 DO BEGIN
      IF (j MOD anz = 0) AND (j>0) THEN s1:='.'+s1;
      INC(j); s1:=s0[i]+s1;
   END;
   StrLong:=s1;
END (* StrLong *);

FUNCTION Str0Long(n,anz:LONGINT):STRING;
VAR s0,s1:STRING; i:INTEGER;
BEGIN
   STR(n,s0); s1:='';
   FOR i:=anz-LENGTH(s0) DOWNTO 1 DO s1:=s1+'0';
   Str0Long:=s1+s0;
END (* Str0Long *);

FUNCTION StrLiLong(n,anz:LONGINT):STRING;
VAR s0,s1:STRING; i:INTEGER;
BEGIN
   STR(n,s0); s1:='';
   FOR i:=anz-LENGTH(s0) DOWNTO 1 DO s1:=s1+' ';
   StrLiLong:=s0+s1;
END (* StrLiLong *);

FUNCTION StrReLong(n,anz:LONGINT):STRING;
VAR s0,s1:STRING; i:INTEGER;
BEGIN
   STR(n,s0); s1:='';
   FOR i:=anz-LENGTH(s0) DOWNTO 1 DO s1:=s1+' ';
   StrReLong:=s1+s0;
END (* StrReLong *);

BEGIN
   {$IFNDEF DOS}
   KEYBOARD_AN:=FALSE;
   (* Die Variable nicht TRUE setzen,
      im Hauptprogramm mte sonst so gesteuert werden:

      IF KEYBOARD_AN THEN InitKeyBoard;

      ... (Programmablauf)

      IF KEYBOARD_AN THEN DoneKeyBoard;

      Mit FALSE wird in Taste0 jedesmal automatisch InitKeyBoard
      und DoneKeyBoard aufgerufen.
   *)
   {$ENDIF}
END (* StdIO.TPU *).
