{$N+}
UNIT Zeit08;      (* (c) ALFWARE Bernd Schubert
                         2012-11-14  20:40:48,17  *)

interface

uses DOS, StdIO;

type MOMENT = record
        jahr, monat, tag, wotag,
        stunde, minute, sekunde,
        hundert, abstag:                longint;
        abssekunde, abshundert:         double;
        heute_feiertag:                 integer;
        welcher_feiertag:array[1..5] of string[30];
     end;

type DIFFMOMENT = record
        ijahr, imonat, itag, iwotag,
        istunde, iminute, isekunde,
        ihundert:                       longint;
        rjahre, rmonate, rwochen,
        rtage, rstunden, rminuten,
        rsekunden:                      double;
     end;

type FT_FELD = record
        ftJAHR,ftANZAHL:                longint;
        FT:array[1..50] of record
           ftNAME:                      string[30];
           ftDATUM: record
              nTAG, nMONAT,
              nIMJAHR, nWOTAG:          longint;
              nWOCHENTAG, nKETTE:       string[10];
           end;
           ftRANG:                      longint;
        end;
        HappyKadaver,Reformationstag,
        AlleHeimlichen,DreiKoenige:     boolean;
     end;

var  Akt_Moment, Test_Moment:MOMENT;  Diff_Moment, Summe_Moment: DIFFMOMENT;

var  Formate: record
        Wochentag:    string[10];
        TT_MM_JJ:     string[8];
        TT_MM_JJJJ:   string[10];
        JJJJ_MM_TT:   string[10];
        HH_MM_SS:     string[8];
        HH_MM_SS_HS:  string[11];
        Timestamp:    string[22];
        Ddatum:       string[9];
        DdatumTzeit:  string[18];
        Datum_Zeit:   string[40];
        Abs_Tag:      longint;
        Abs_Hundert:  double;
     end;

var Diff_TimeStamp, Summe_TimeStamp:string[22];
    Diff_TimeStamp24, Summe_TimeStamp24:string[12]; (* 999h *)

var  Feiertage: FT_FELD;

function StopUhr(Kommentar: string):string;
(* Neue StechUhr TimeStamp als Ausgabestring *)

function Intervall_Start:string;
(* Programmstart-Zeitpunkt *)

function Intervall_Stop:string;
(* Programmende-Zeitpunkt *)

function Intervall_Dauer:string;
(* Programmdauer Stop minus Start *)

procedure Steche_Moment;
(* GetDate und GetTime *)

procedure Konvert_Timestamp(t: string);
(* erstellt den Moment aus String timestamp *)

procedure Formate_Moment(M: Moment);
(* Formatiert die Werte im Moment *)

procedure Zeige_Formate;
(* Zeigt die formatierten Werte im Moment an *)

function  Gueltig_Moment(M: Moment):boolean;
(* Stehen im Moment gltige Werte? *)

function  Historisch_Test_Moment:boolean;
(* Ist Test_Moment < Akt_Moment *)

procedure Manuell_Moment(var M: Moment;
                         pjahr, pmonat, ptag, pstunde, pminute, psekunde, phundert:longint);
(* dem Moment die Werte zuweisen *)

procedure Addiere_Moment(var M: Moment;
                         pjahr, pmonat, ptag, pstunde, pminute, psekunde, phundert:longint);
(* dem Moment die Werte aufaddieren *)

procedure Dezimale_Moment(var M: Moment);
(* Umrechnen Momente in absolute Zahlen *)

procedure SetzeNull_Summe_Moment;
(* Setzt Summe_Moment auf Null *)

procedure Addiere_Summe_Moment;
(* Summe_Moment = Summe_Moment + Diff_Moment
   und danach normalisieren                  *)

procedure Differenz_Moment;
(* Diff_Moment = Akt_Moment - Test_Moment *)

procedure Normiere_Moment(var M: Moment);
(* wandelt einen "aufaddierten" Moment um in einen gltigen Moment *)

function Feiertage_Bestimmen(OST_JAHR: integer):boolean;
(* Bestimmt fr ein Jahr die Feiertage... *)

function Feiertage_Eintragen(var M: Moment):integer;
(* Schaut nach, ob in der Feiertagstabelle Eintrge fr den Akt_Moment sind? *)

procedure Feiertage_Sortieren;
(* Sortiert die aktuellen Feiertage *)

procedure Neuer_Feiertag_Nach_Datum(F_TAG,F_MON,F_JAHR: integer; F_NAME: string);
(* Fgt einen neuen Feiertag hinzu mit TT.MM.JJJJ *)

procedure Neuer_Feiertag_Wochentag_ab_Datum(F_TAG,F_MON,F_JAHR: integer; F_NAME,F_WOCHENTAG: string);
(* Fgt einen neuen Feiertag hinzu, fester Wochentag ab TT.MM.JJJJ *)

procedure Neuer_Feiertag_Nach_AbsTag(F_ABS,F_JAHR: integer; F_NAME: string);
(* Fgt einen neuen Feiertag hinzu, "absoluter" Tag im Jahr *)
(* Der Tag kann natrlich wie bei Ostern/Pfingsten abhngig berechnet werden *)

implementation

const Wochen_Tage: array[1..7] of string[10] =
      ('Montag', 'Dienstag', 'Mittwoch', 'Donnerstag',
       'Freitag', 'Sonnabend', 'Sonntag');

const Monatsnamen: array[1..12] of string[9] =
      ('Januar', 'Februar', 'Mrz', 'April','Mai','Juni','Juli',
       'August','September', 'Oktober', 'November','Dezember');

const Monatsende: array[0..13] of integer =
      (31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31);

var Sicher_Moment, Puffer_Moment: MOMENT;
    ii: integer;

procedure Steche_Moment;
var stroh1,stroh2,stroh3,stroh4:word;
begin
   GetTime(stroh1,stroh2,stroh3,stroh4);
   Akt_Moment.stunde    := stroh1;
   Akt_Moment.minute    := stroh2;
   Akt_Moment.sekunde   := stroh3;
   Akt_Moment.hundert   := stroh4;
   GetDate(stroh1,stroh2,stroh3,stroh4);
   Akt_Moment.jahr      := stroh1;
   Akt_Moment.monat     := stroh2;
   Akt_Moment.tag       := stroh3;
   Akt_Moment.wotag     := stroh4+1;
end (* Steche_Moment *);

function StopUhr(Kommentar: string):string;
var KM:string;
begin
   KM:=Kommentar; if KM=':' then KM:='StopUhr: ';
   Steche_Moment;
   Formate_Moment(Akt_Moment);
   StopUhr:=KM+Formate.TimeStamp;
end (* Stop_Uhr *);

function Intervall_Start:string;
begin
   Intervall_Start:=StopUhr('Start:');
   Test_Moment:=Akt_Moment;
end;

function Intervall_Stop:string;
begin
   Intervall_Stop:=StopUhr('Stop: ');
end;

function Intervall_Dauer:string;
var dauer:string;
begin
   Differenz_Moment;
   dauer:=COPY(Diff_TimeStamp,12,255);
   if Diff_Moment.rtage>=1
      then dauer:=StrLong(Trunc(Diff_Moment.rtage),3)+'T '+dauer;
   Intervall_dauer:='Dauer:'+dauer;
end;

procedure Konvert_Timestamp(t: string);
var kjahr,kmonat,ktag,kstunde,kminute,ksekunde,khundert:longint;
    w:word;
begin
   val(copy(t,1,2),ktag,w);
   val(copy(t,4,2),kmonat,w);
   val(copy(t,7,4),kjahr,w);
   val(copy(t,12,2),kstunde,w);
   val(copy(t,15,2),kminute,w);
   val(copy(t,18,2),ksekunde,w);
   val(copy(t,21,2),khundert,w);
   Manuell_Moment(Akt_Moment,kjahr,kmonat,ktag,kstunde,kminute,ksekunde,khundert);
   Normiere_Moment(Akt_Moment);
   Formate_Moment(Akt_Moment);
end;

procedure Formate_Moment(M: Moment);
begin
   Formate.Wochentag    := Wochen_Tage[M.wotag];
   Formate.TT_MM_JJ     := str0(M.tag,2)+'.'+
                           str0(M.monat,2)+'.'+
                           str0(M.jahr mod 100,2);
   Formate.TT_MM_JJJJ   := str0(M.tag,2)+'.'+
                           str0(M.monat,2)+'.'+
                           str0(M.jahr,4);
   Formate.JJJJ_MM_TT   := str0(M.jahr,4)+'-'+
                           str0(M.monat,2)+'-'+
                           str0(M.tag,2);
   Formate.HH_MM_SS     := str0(M.stunde,2)+':'+
                           str0(M.minute,2)+':'+
                           str0(M.sekunde,2);
   Formate.HH_MM_SS_HS  := str0(M.stunde,2)+':'+
                           str0(M.minute,2)+':'+
                           str0(M.sekunde,2)+','+
                           str0(M.hundert,2);
   Formate.Timestamp    := str0(M.tag,2)+'.'+
                           str0(M.monat,2)+'.'+
                           str0(M.jahr,4)+' '+
                           Formate.HH_MM_SS_HS;
   Formate.DdatumTzeit  := 'D'+str0(M.jahr,4)+
                           str0(M.monat,2)+
                           str0(M.tag,2)+
                           'T'+str0(M.stunde,2)+
                           str0(M.minute,2)+
                           str0(M.sekunde,2)+
                           str0(M.hundert,2);
   Formate.Ddatum       := 'D'+str0(M.jahr,4)+
                           str0(M.monat,2)+
                           str0(M.tag,2);
   Formate.Datum_Zeit   := Formate.Wochentag+', '+
                           str0(M.tag,2)+'. '+
                           Monatsnamen[M.monat]+' '+
                           str0(M.jahr,4)+', ' +
                           Formate.HH_MM_SS;
   Formate.Abs_Tag      := M.abstag;
   Formate.Abs_Hundert  := M.abshundert;
end (* Formate_Moment *);

procedure Zeige_Formate;
begin
   WriteLn('Wochentag     = ',Formate.Wochentag);
   WriteLn('TT.MM.JJ      = ',Formate.TT_MM_JJ);
   WriteLn('TT.MM.JJJJ    = ',Formate.TT_MM_JJJJ);
   WriteLn('JJJJ-MM-TT    = ',Formate.JJJJ_MM_TT);
   WriteLn('HH:MM:SS      = ',Formate.HH_MM_SS);
   WriteLn('HH:MM:SS,HS   = ',Formate.HH_MM_SS_HS);
   WriteLn('Timestamp     = ',Formate.Timestamp);
   WriteLn('Datum/Zeit    = ',Formate.Datum_Zeit);
   WriteLn('absolute Zeit = ',Formate.Abs_Tag,' Tage == ',
                              Formate.Abs_Hundert, ' ms');
end (* Zeige_Format *);

function schalt(monat,jahr: longint):boolean;
begin
   schalt:=(monat=2) and ( (jahr mod 4 = 0) and
                          ((jahr mod 100 <> 0) or (jahr mod 400 = 0)));
end (* schalt *);

function  Gueltig_Moment(M: Moment):boolean;
var tempbool: boolean;
begin
   tempbool:=true;
   if M.jahr < 0 then tempbool:=false;
   if (M.tag<1) then tempbool:=false;
   case M.monat of
      1,3,5,7,8,10,12: if M.tag>31 then tempbool:=false;
      2: begin
            if schalt(M.monat,M.jahr)
               then if M.tag>29 then tempbool:=false else
               else if M.tag>28 then tempbool:=false
         end;
      4,6,9,11: if M.tag>30 then tempbool:=false;
      else tempbool:=false;
   end;
   if (M.stunde  < 0) or (M.stunde  > 23) then tempbool:=false;
   if (M.minute  < 0) or (M.minute  > 59) then tempbool:=false;
   if (M.sekunde < 0) or (M.sekunde > 59) then tempbool:=false;
   if (M.hundert < 0) or (M.hundert > 99) then tempbool:=false;
   Gueltig_Moment:=tempbool;
end (* Gueltig_Moment *);

function Historisch_Test_Moment:boolean;
begin
   Dezimale_Moment(Test_Moment);
   Dezimale_Moment(Akt_Moment);
   Historisch_Test_Moment:=(Test_Moment.abshundert < Akt_Moment.abshundert);
end (* Historisch_Moment *);

procedure Manuell_Moment(var M: Moment;
                         pjahr, pmonat, ptag, pstunde, pminute, psekunde, phundert:longint);
begin
   if pjahr<>-1     then M.jahr:=   pjahr;
   if pmonat<>-1    then M.monat:=  pmonat;
   if ptag<>-1      then M.tag:=    ptag;
   if pstunde<>-1   then M.stunde:= pstunde;
   if pminute<>-1   then M.minute:= pminute;
   if psekunde<>-1  then M.sekunde:=psekunde;
   if phundert<>-1  then M.hundert:=phundert;
end (* Manuell_Moment *);

procedure Addiere_Moment(var M: Moment;
                         pjahr, pmonat, ptag, pstunde, pminute, psekunde, phundert:longint);
begin
   if pjahr>0     then M.jahr:=   M.jahr    + pjahr;
   if pmonat>0    then M.monat:=  M.monat   + pmonat;
   if ptag>0      then M.tag:=    M.tag     + ptag;
   if pstunde>0   then M.stunde:= M.stunde  + pstunde;
   if pminute>0   then M.minute:= M.minute  + pminute;
   if psekunde>0  then M.sekunde:=M.sekunde + psekunde;
   if phundert>0  then M.hundert:=M.hundert + phundert;
end (* Addiere_Moment *);

procedure Dezimale_Moment(var M: Moment);
var dmonate,djahre:longint;
begin
   M.abstag:=    M.tag-1;
   dmonate:=     M.monat-1;
   djahre:=      M.jahr-1;
   if schalt(2,M.jahr) then monatsende[2]:=29 else monatsende[2]:=28;
   while dmonate > 0 do begin;
      M.abstag:=M.abstag+monatsende[dmonate];
      DEC(dmonate);
   end;
   while djahre > 0 do begin;
      if schalt(2,djahre)
         then M.abstag:=M.abstag+366
         else M.abstag:=M.abstag+365;
      DEC(djahre);
   end;
   M.abshundert:=M.abstag;
   M.abshundert:=M.abshundert*8640000
                +M.stunde*360000
                +M.minute*6000
                +M.sekunde*100
                +M.hundert;
   M.abssekunde:=INT(M.abshundert/100.00);
   monatsende[2]:=28;
end (* Dezimale_Moment *);

procedure SetzeNull_Summe_Moment;
begin
   Summe_Moment.ihundert:=  0;
   Summe_Moment.isekunde:=  0;
   Summe_Moment.iminute:=   0;
   Summe_Moment.istunde:=   0;
   Summe_Moment.itag:=      0;
   Summe_Moment.imonat:=    0;
   Summe_Moment.ijahr:=     0;
   Summe_Moment.rsekunden:= 0.0;
   Summe_Moment.rminuten:=  0.0;
   Summe_Moment.rstunden:=  0.0;
   Summe_Moment.rtage:=     0.0;
   Summe_Moment.rjahre:=    0.0;
   Summe_Moment.rmonate:=   0.0;
   Summe_Moment.rwochen:=   0.0;
   Summe_TimeStamp:='00.00.0000 00:00:00,00';
   (* die Monate/Jahre vernachlssigen wir hier bis zum Beweis des Gegenteils *)
   Summe_TimeStamp24:='00:00:00,00';
end (* SetzeNull_Summe_Moment *);

procedure Addiere_Summe_Moment;
begin
   Summe_Moment.ihundert:= Summe_Moment.ihundert + Diff_Moment.ihundert;
   Summe_Moment.isekunde:= Summe_Moment.isekunde + Diff_Moment.isekunde;
   Summe_Moment.iminute := Summe_Moment.iminute  + Diff_Moment.iminute;
   Summe_Moment.istunde := Summe_Moment.istunde  + Diff_Moment.istunde;
   Summe_Moment.itag    := Summe_Moment.itag     + Diff_Moment.itag;
   Summe_Moment.imonat  := Summe_Moment.imonat   + Diff_Moment.imonat;
   Summe_Moment.ijahr   := Summe_Moment.ijahr    + Diff_Moment.ijahr;
   while Summe_Moment.ihundert>99 do begin
      dec(Summe_Moment.ihundert,100); inc(Summe_Moment.isekunde);
   end;
   while Summe_Moment.isekunde>59 do begin
      dec(Summe_Moment.isekunde,60); inc(Summe_Moment.iminute);
   end;
   while Summe_Moment.iminute>59 do begin
      dec(Summe_Moment.iminute,60); inc(Summe_Moment.istunde);
   end;
   while Summe_Moment.istunde>23 do begin
      dec(Summe_Moment.istunde,24); inc(Summe_Moment.itag);
   end;
   while Summe_Moment.itag>30 do begin
      dec(Summe_Moment.isekunde,31); inc(Summe_Moment.imonat);
   end;
   while Summe_Moment.imonat>11 do begin
      dec(Summe_Moment.imonat,12); inc(Summe_Moment.ijahr);
   end;
   Summe_Moment.rsekunden:= Summe_Moment.ihundert*1.0;
   Summe_Moment.rsekunden:= Summe_Moment.rsekunden / 100.00;
   Summe_Moment.rminuten:=  Summe_Moment.rsekunden / 60.00;
   Summe_Moment.rstunden:=  Summe_Moment.rminuten  / 60.00;
   Summe_Moment.rtage:=     Summe_Moment.rstunden  / 24.00;
   Summe_Moment.rjahre:=    Summe_Moment.rtage     / 365.22;
   Summe_Moment.rmonate:=   Summe_Moment.rjahre    * 12.00;
   Summe_Moment.rwochen:=   Summe_Moment.rtage     / 7.00;
   Summe_TimeStamp:=str0(Summe_Moment.itag,2)+'.'+
                    str0(Summe_Moment.imonat,2)+'.'+
                    str0(Summe_Moment.ijahr,4)+' '+
                    str0(Summe_Moment.istunde,2)+':'+
                    str0(Summe_Moment.iminute,2)+':'+
                    str0(Summe_Moment.isekunde,2)+','+
                    str0(Summe_Moment.ihundert,2);
   (* die Monate/Jahre vernachlssigen wir hier bis zum Beweis des Gegenteils *)
   Summe_TimeStamp24:=str0(Summe_Moment.istunde+24*Summe_Moment.itag,2)+':'+
                   str0(Summe_Moment.iminute,2)+':'+
                   str0(Summe_Moment.isekunde,2)+','+
                   str0(Summe_Moment.ihundert,2);
end (* Addiere_Summe_Moment *);

procedure Differenz_Moment;
var iii,jjj:longint;
begin
   Puffer_Moment:=Akt_Moment;
   if Akt_Moment.hundert > Test_Moment.hundert-1
      then Diff_Moment.ihundert:=Akt_Moment.hundert-Test_Moment.hundert
      else begin;
         Diff_Moment.ihundert:=Akt_Moment.hundert+100-Test_Moment.hundert;
         DEC(Akt_Moment.sekunde)
   end;
   if Akt_Moment.sekunde > Test_Moment.sekunde-1
      then Diff_Moment.isekunde:=Akt_Moment.sekunde-Test_Moment.sekunde
      else begin;
         Diff_Moment.isekunde:=Akt_Moment.sekunde+60-Test_Moment.sekunde;
         DEC(Akt_Moment.minute)
   end;
   if Akt_Moment.minute > Test_Moment.minute-1
      then Diff_Moment.iminute:=Akt_Moment.minute-Test_Moment.minute
      else begin;
         Diff_Moment.iminute:=Akt_Moment.minute+60-Test_Moment.minute;
         DEC(Akt_Moment.stunde)
    end;
   if Akt_Moment.stunde > Test_Moment.stunde-1
      then Diff_Moment.istunde:=Akt_Moment.stunde-Test_Moment.stunde
      else begin;
         Diff_Moment.istunde:=Akt_Moment.stunde+24-Test_Moment.stunde;
         DEC(Akt_Moment.tag)
   end;
   if Akt_Moment.tag > Test_Moment.tag-1
      then Diff_Moment.itag:=Akt_Moment.tag-Test_Moment.tag
      else begin;
         Diff_Moment.itag:=Akt_Moment.tag+monatsende[Akt_Moment.monat-1]-Test_Moment.tag;
         DEC(Akt_Moment.monat)
       end;
   if schalt(Akt_Moment.monat, Akt_Moment.jahr) then INC(Diff_Moment.itag);
   if Akt_Moment.monat > Test_Moment.monat-1
      then Diff_Moment.imonat:=Akt_Moment.monat-Test_Moment.monat
      else begin;
         Diff_Moment.imonat:=Akt_Moment.monat+12-Test_Moment.monat;
         DEC(Akt_Moment.jahr)
   end;
   Diff_Moment.ijahr:=Akt_Moment.jahr-Test_Moment.jahr;
   Akt_Moment:=Puffer_Moment;
   Dezimale_Moment(Akt_Moment);
   Dezimale_Moment(Test_Moment);
   Diff_Moment.rsekunden:= Akt_Moment.abshundert - Test_Moment.abshundert;
   Diff_Moment.rsekunden:= Diff_Moment.rsekunden / 100.00;
   Diff_Moment.rminuten:=  Diff_Moment.rsekunden / 60.00;
   Diff_Moment.rstunden:=  Diff_Moment.rminuten  / 60.00;
   Diff_Moment.rtage:=     Diff_Moment.rstunden  / 24.00;
   Diff_Moment.rjahre:=    Diff_Moment.rtage     / 365.22;
   Diff_Moment.rmonate:=   Diff_Moment.rjahre    * 12.00;
   Diff_Moment.rwochen:=   Diff_Moment.rtage     / 7.00;
   Diff_TimeStamp:=str0(Diff_Moment.itag,2)+'.'+
                   str0(Diff_Moment.imonat,2)+'.'+
                   str0(Diff_Moment.ijahr,4)+' '+
                   str0(Diff_Moment.istunde,2)+':'+
                   str0(Diff_Moment.iminute,2)+':'+
                   str0(Diff_Moment.isekunde,2)+','+
                   str0(Diff_Moment.ihundert,2);
   (* die Monate/Jahre vernachlssigen wir hier bis zum Beweis des Gegenteils *)
   Diff_TimeStamp24:=str0(Diff_Moment.istunde+24*Diff_Moment.itag,2)+':'+
                   str0(Diff_Moment.iminute,2)+':'+
                   str0(Diff_Moment.isekunde,2)+','+
                   str0(Diff_Moment.ihundert,2);
end (* Differenz_Moment *);

procedure Normiere_Moment(var M: Moment);
var bjahr, bmonat, btag, bstunde,
    bminute, bsekunde, bhundert: longint;
begin
   monatsende[2]:=28;
   bhundert:=   M.hundert;
   M.hundert:=  M.hundert mod 100;
   M.sekunde:=  M.sekunde + bhundert div 100;
   bsekunde:=   M.sekunde;
   M.sekunde:=  M.sekunde mod 60;
   M.minute:=   M.minute  + bsekunde div 60;
   bminute:=    M.minute;
   M.minute:=   M.minute  mod 60;
   M.stunde:=   M.stunde  + bminute  div 60;
   bstunde:=    M.stunde;
   M.stunde:=   M.stunde  mod 24;
   M.tag:=      M.tag     + bstunde  div 24;
   bmonat:=     M.monat;
   M.monat:=    M.monat   mod 12;  if M.monat = 0 then M.monat:= 12;
   M.jahr:=     M.jahr    + ((bmonat - M.monat) div 12);
   if schalt(2,M.jahr) then monatsende[2]:=29 else monatsende[2]:=28;
   while (M.tag > monatsende[M.monat]) do begin;
      M.tag:= M.tag - monatsende[M.monat];
      if M.monat < 12
         then INC(M.monat)
         else begin; M.monat:=1; INC(M.jahr); end;
      if schalt(2,M.jahr) then monatsende[2]:=29 else monatsende[2]:=28;
   end;
   Dezimale_Moment(M);   (* <=== *) monatsende[2]:=28;
   M.wotag:=(M.abstag mod 7) + 1;
end (* Normiere_Moment *);

function Feiertage_Bestimmen(OST_JAHR: integer):boolean;
var OST_N,OST_A,OST_B,OST_M,OST_Q,OST_W:integer;
    OST_TAG,OST_MON,OST_ABS,TAG_ABS:integer;
begin
   with Feiertage do begin ftJAHR:=OST_JAHR; ftANZAHL:=0;
   if (OST_JAHR < 1900 ) or (OST_JAHR > 2099) then begin;
      ftANZAHL:=0; Feiertage_Bestimmen:=false; exit
   end;
   OST_N  := OST_JAHR - 1900;
   OST_A  := OST_N mod 19;
   OST_B  :=( 7*OST_A + 1) div 19;
   OST_M  :=(11*OST_A + 4 - OST_B) mod 29;
   OST_Q  := OST_N div 4;
   OST_W  :=(OST_N + OST_Q + 31 - OST_M) mod 7;
   OST_TAG:= 25 - OST_M - OST_W;
   if (OST_TAG < 1)
      then begin OST_MON:=3; OST_TAG:=OST_TAG+31; end
      else       OST_MON:=4;
   Feiertage_Bestimmen:=true;
   Neuer_Feiertag_Nach_Datum(OST_TAG,OST_MON,OST_JAHR,'Ostersonntag');
   OST_ABS:=FT[1].ftDATUM.nIMJAHR;
   Neuer_Feiertag_Nach_ABSTag(OST_ABS+1,OST_JAHR,'Ostermontag');
   Neuer_Feiertag_Nach_ABSTag(OST_ABS-2,OST_JAHR,'Karfreitag');
   Neuer_Feiertag_Nach_ABSTag(OST_ABS+38,OST_JAHR,'Himmelfahrt');
   Neuer_Feiertag_Nach_ABSTag(OST_ABS-53,OST_JAHR,'Weiberfastnacht');
   Neuer_Feiertag_Nach_ABSTag(OST_ABS-49,OST_JAHR,'Rosenmontag');
   Neuer_Feiertag_Nach_ABSTag(OST_ABS-48,OST_JAHR,'Fastnacht');
   Neuer_Feiertag_Nach_ABSTag(OST_ABS-47,OST_JAHR,'Aschermittwoch');
   Neuer_Feiertag_Nach_ABSTag(OST_ABS+48,OST_JAHR,'Pfingstsonntag');
   Neuer_Feiertag_Nach_ABSTag(OST_ABS+49,OST_JAHR,'Pfingstmontag');
   if HappyKadaver then Neuer_Feiertag_Nach_ABSTag(OST_ABS+59,OST_JAHR,'Happy Kadaver');
   if Reformationstag then Neuer_Feiertag_Nach_Datum(31,10,OST_JAHR,'Reformationstag');
   if AlleHeimlichen then Neuer_Feiertag_Nach_Datum(1,11,OST_JAHR,'AlleHeimlichen');
   if DreiKoenige then Neuer_Feiertag_Nach_Datum(6,1,OST_JAHR,'3 Knige');
   Neuer_Feiertag_Nach_Datum(1,7,OST_JAHR,'Geburtstag');
   Neuer_Feiertag_Nach_Datum(1,5,OST_JAHR,'1.Mai');
   Neuer_Feiertag_Nach_Datum(3,10,OST_JAHR,'3.Oktober');
   Neuer_Feiertag_Nach_Datum(1,1,OST_JAHR,'Neujahr');
   Neuer_Feiertag_Nach_Datum(31,12,OST_JAHR,'Silvester');
   Neuer_Feiertag_Nach_Datum(24,12,OST_JAHR,'Heiligabend');
   Neuer_Feiertag_Nach_Datum(25,12,OST_JAHR,'1.Weihnachtstag');
   Neuer_Feiertag_Nach_Datum(26,12,OST_JAHR,'2.Weihnachtstag');
   Neuer_Feiertag_Wochentag_ab_Datum(8,5,OST_JAHR,'Muttertag','Sonntag');
   Neuer_Feiertag_Wochentag_ab_Datum(18,12,OST_JAHR,'4.Advent','Sonntag');
   TAG_ABS:=FT[ftANZAHL].ftDATUM.nIMJAHR-1;
   Neuer_Feiertag_Nach_ABSTag(TAG_ABS-21,OST_JAHR,'1.Advent');
   Neuer_Feiertag_Nach_ABSTag(TAG_ABS-14,OST_JAHR,'2.Advent');
   Neuer_Feiertag_Nach_ABSTag(TAG_ABS-7,OST_JAHR,'3.Advent');

   Feiertage_Sortieren;
end end (* Feiertage bestimmen *);

procedure Feiertage_Sortieren;
var sor_I,sor_K,sor_INDEX,sor_MINIMUM:integer;
begin
   with Feiertage do begin
   for sor_I:=1 to ftANZAHL do with FT[sor_I] do begin;
      sor_MINIMUM:=999; sor_INDEX:=0;
      for sor_K:=1 to ftANZAHL do with FT[sor_K] do with ftDATUM do begin;
         if (nIMJAHR<sor_MINIMUM) and (ftRANG=0) then begin
            sor_INDEX:=sor_K; sor_MINIMUM:=nIMJAHR;
         end;
      end;
      FT[sor_INDEX].ftRANG:=sor_I;
   end end;
end (* Feiertage_Sortieren *);

procedure Neuer_Feiertag_Nach_Datum(F_TAG,F_MON,F_JAHR: integer; F_NAME: string);
begin
   Sicher_Moment:=Akt_Moment;
   inc(Feiertage.ftANZAHL);
   if Feiertage.ftANZAHL>50 then Feiertage.ftANZAHL:=1;
   with Feiertage do with FT[ftANZAHL] do with ftDATUM do begin
      ftJAHR:=F_JAHR;
      Manuell_Moment(Akt_Moment,F_JAHR,F_MON,F_TAG,0,0,0,0);
      Manuell_Moment(Test_Moment,F_JAHR,1,1,0,0,0,0);
      Differenz_Moment;
      Normiere_Moment(Akt_Moment); Formate_Moment(Akt_Moment);
      with Akt_Moment do with Formate do begin
      ftNAME:=F_NAME; nIMJAHR:=TRUNC(Diff_Moment.rtage)+1; ftRANG:=0;
      nTAG:=tag; nMONAT:=monat; nWOTAG:=wotag;
      nWOCHENTAG:=Formate.WochenTag; nKETTE:=TT_MM_JJJJ;
   end end;
   Akt_Moment:=Sicher_Moment;
   Normiere_Moment(Akt_Moment);
   Formate_Moment(Akt_Moment);
end (* Neuer_Feiertag_Nach_Datum *);

procedure Neuer_Feiertag_Wochentag_ab_Datum(F_TAG,F_MON,F_JAHR: integer; F_NAME,F_WOCHENTAG: string);
begin
   Sicher_Moment:=Akt_Moment;
   inc(Feiertage.ftANZAHL);
   if Feiertage.ftANZAHL>50 then Feiertage.ftANZAHL:=1;
   with Feiertage do with FT[ftANZAHL] do with ftDATUM do begin
      ftJAHR:=F_JAHR;
      Manuell_Moment(Akt_Moment,F_JAHR,F_MON,F_TAG,0,0,0,0);
      Manuell_Moment(Test_Moment,F_JAHR,1,1,0,0,0,0);
      Differenz_Moment; nIMJAHR:=TRUNC(Diff_Moment.rtage)+1;
      repeat
         Normiere_Moment(Akt_Moment); Formate_Moment(Akt_Moment);
         with Akt_Moment do with Formate do begin
            ftNAME:=F_NAME;  ftRANG:=0;
            nTAG:=tag; nMONAT:=monat; nWOTAG:=wotag;
            nWOCHENTAG:=Formate.WochenTag; nKETTE:=TT_MM_JJJJ;
            if nWOCHENTAG<>F_WOCHENTAG then begin;
               Addiere_Moment(Akt_Moment,0,0,1,0,0,0,0);
               inc(nIMJAHR);
            end
         end
      until (nWOCHENTAG=F_WOCHENTAG)or((nTAG=31)and(nMONAT=12));
   end;
   Akt_Moment:=Sicher_Moment;
   Normiere_Moment(Akt_Moment);
   Formate_Moment(Akt_Moment);
end (* Neuer_Feiertag_Wochentage_ab_Datum *);

procedure Neuer_Feiertag_Nach_AbsTag(F_ABS,F_JAHR: integer; F_NAME: string);
begin
   Sicher_Moment:=Akt_Moment;
   inc(Feiertage.ftANZAHL);
   if Feiertage.ftANZAHL>50 then Feiertage.ftANZAHL:=1;
   with Feiertage do with FT[ftANZAHL] do with ftDATUM do begin
      ftJAHR:=F_JAHR;
      Manuell_Moment(Akt_Moment,F_JAHR,1,1,0,0,0,0);
      Addiere_Moment(Akt_Moment,0,0,F_ABS,0,0,0,0);
      Normiere_Moment(Akt_Moment); Formate_Moment(Akt_Moment);
      with Akt_Moment do with Formate do begin
         ftNAME:=F_NAME; nIMJAHR:=F_ABS+1; ftRANG:=0;
         nTAG:=tag; nMONAT:=monat; nWOTAG:=wotag;
         nWOCHENTAG:=Formate.WochenTag; nKETTE:=TT_MM_JJJJ;
      end
   end;
   Akt_Moment:=Sicher_Moment;
   Normiere_Moment(Akt_Moment);
   Formate_Moment(Akt_Moment);
end (* Neuer_Feiertag_Nach_AbsTag *);

function Feiertage_Eintragen(var M:Moment):integer;
var jj:integer;
begin
   with Feiertage do begin;
      M.heute_feiertag:=0;
      for jj:=1 to ftANZAHL do with FT[jj] do begin
         if (M.jahr=ftJAHR)and(M.tag=ftDatum.nTAG)and(M.monat=ftDatum.nMONAT) then begin;
            inc(M.heute_feiertag); if M.heute_feiertag>5 then M.heute_feiertag:=1;
            M.welcher_feiertag[M.heute_feiertag]:=ftNAME;
         end;
      end
   end;
end (* Feiertage eintragen *);

begin
   Feiertage.HappyKadaver:=true;
   Feiertage.Reformationstag:=true;
   Feiertage.AlleHeimlichen:=true;
   Feiertage.DreiKoenige:=true;
   Akt_Moment.heute_feiertag:=0;
   Test_Moment.heute_feiertag:=0;
   for ii:=1 to 5 do begin
      Akt_Moment.welcher_feiertag[ii]:='';
      Test_Moment.welcher_feiertag[ii]:='';
      Puffer_Moment.welcher_feiertag[ii]:='';
   end;
   with Feiertage do begin ftJAHR:=1966; ftANZAHL:=0; end;
end (* Zeit08.TPU *).
