PROGRAM QSort;

{$UNDEF FPC_HAS_FEATURE_ANSISTRINGS}
{$UNDEF FPC_HAS_CPSTRING}
{$DEFINE DisableUTF8RTL}

{$IFDEF DOS} {$M 65520,0,655360} {$N+} {$ELSE} {$H-} {$ENDIF}
USES STDIO, {$IFDEF FPCDATA} ZEIT {$ELSE} ZEIT08 {$ENDIF} , STRINGS, DOS;
(* siehe Hinweis zur Einbindung ZEIT/ZEIT08 in dieser Unit *)

CONST VERSION_INFO = 'QSORT   Sortierprogramm   ' +
{$IFDEF DOS} 'V 5.31 (16bit) 02/2016'
{$ELSE}      'V 5.31  02/2016       '
{$ENDIF} +   '   (c) ALFWARE B.Schubert';

TYPE  CARDINT = {$IFDEF DOS} LONGINT    {$ELSE} INT64               {$ENDIF};
CONST MAXCARD = {$IFDEF DOS} MAXLONGINT {$ELSE} 9223372036854775807 {$ENDIF};

CONST feld:ARRAY[0..25] OF CHAR =
      ('A','B','C','D','E','F','G','H','I','J',
       'K','L','M','N','O','P','Q','R','S','T',
       'U','V','W','X','Y','Z');
      keylang:     LONGINT    = 133;
      reverse:     BOOLEAN    = FALSE;
      buffermax:   LONGINT    = 0;
      abspalte:    LONGINT    = 1;
      bisspalte:   LONGINT    = 255;
      tempbest:    STRING[8]  = '_TEMP_';
      tempverz:    STRING     = '';
      funktion:    BYTE       = 7;
      baumalgo:    BOOLEAN    = FALSE;
      temploes:    BOOLEAN    = TRUE;
      bufferdyn:   BOOLEAN    = FALSE;
      temperst:    LONGINT    = 1;
      dynlaenge:   LONGINT    = {$IFDEF DOS} 5000 {$ELSE} 20000000 {$ENDIF};
      dynoptm:     LONGINT    = {$IFDEF DOS} 5000 {$ELSE}  1000000 {$ENDIF};
      blattlaenge: LONGINT    = 0;
      blattanzahl: LONGINT    = 0;
      blattmax:    LONGINT    = {$IFDEF DOS}  999 {$ELSE} 999999 {$ENDIF};
      blattoptm:   LONGINT    = {$IFDEF DOS}  999 {$ELSE}  99999 {$ENDIF};
      baumstart:   LONGINT    = 1;
      baumende:    LONGINT    = 0;
      baumfrei:    BOOLEAN    = TRUE;
      fehlerfrei:  BOOLEAN    = TRUE;
      versuchja:   BOOLEAN    = TRUE;
      memonutz:    LONGINT    = 0;
      timeout:     LONGINT    = 0;
      einname:     STRING     = '';
      ausname:     STRING     = '';
      einok:       BOOLEAN    = FALSE;
      EOF2:        BOOLEAN    = FALSE;
      ausok:       BOOLEAN    = FALSE;
      fileok:      BOOLEAN    = TRUE;
      zeilenmax:   CARDINT    = MAXCARD;
      zaehlen:     BOOLEAN    = TRUE;
      grossklein:  BOOLEAN    = TRUE;
      fortschritt: CHAR       = 'S';
      SortLn:      LONGINT    = 0;
      nureins:     LONGINT    = 0;
      anzahl:      CARDINT    = 0;
      alle:        CARDINT    = 0;
      mischanzahl: CARDINT    = 0;
      punktaus:    CARDINT    = 1000000;
      TEILE = 0; SORTIERE = 1; MISCHE = 2;

TYPE  SCHLUESSEL = PCHAR;
      ZEIGER = ^SATZ;
      SATZ = RECORD
         link: ZEIGER;
         key: SCHLUESSEL;
      END;
      STRING16 = STRING[16];
      TBAUM = RECORD
         links,rechts,datei: LONGINT;
         status: CHAR;
      END;
      BUFFTYP = ARRAY[1.. {$IFDEF DOS} 32*1024
                          {$ELSE}      64*1024 {$ENDIF} ] OF BYTE;

VAR anker,endeanker: ZEIGER;
    zeile0,zeile1,stra,strb,start0,stop0: STRING;
    datei: ARRAY[1..15] OF RECORD
       name: TEXT;
       fname: STRING16;
       zeile: STRING;
       io: BOOLEAN;
       {$IFNDEF DOS} buf:BUFFTYP; {$ENDIF}
    END;

    baum:ARRAY {$IFDEF DOS} [1..2048] {$ENDIF} OF TBAUM;
    aeste:ARRAY[1..22] of LONGINT;
    {$IFNDEF DOS} HeapStatusFPC:TFPCHeapStatus; {$ELSE} heap:POINTER; {$ENDIF}
    zeilenzahl: CARDINT;
    eindatei,ausdatei: TEXT;
    {$IFNDEF DOS} einbuf,ausbuf(*,inbuf*),outbuf: BUFFTYP; {$ENDIF}

LABEL QSE;

{$IFNDEF DOS}
{PROCEDURE RestoreFlush(VAR t: TEXT);
BEGIN
   TextRec(t).FlushFunc:=TextRec(t).InOutFunc;
END;}

PROCEDURE SetBufferAndNoFlush(VAR t: TEXT; VAR buffer: BUFFTYP; io:BOOLEAN);
BEGIN
   SetTextBuf(t, buffer, sizeof(buffer));
   IF io THEN TextRec(t).FlushFunc:=NIL;
END; {$ENDIF}

{$IFDEF DOS} FUNCTION StrHex(n,anz: LONGINT):STRING;
VAR s0,s1: STRING;
    h,i: LONGINT;
BEGIN
  STR(n,s0); s1:='';
  h:=n DIV 100;
  IF h>9 THEN s0:=feld[h-10]+COPY(s0,3,255);
  FOR i:=anz-LENGTH(s0) DOWNTO 1 DO s1:=s1+'0';
  StrHex:=s1+s0;
END; {$ENDIF}

FUNCTION StrCardInt(n: CARDINT):STRING;
BEGIN
   StrCardInt:={$IFDEF DOS} StrLong {$ELSE} StrInt64 {$ENDIF} (n);
END;

FUNCTION Str0CardInt(n: CARDINT; anz:INTEGER):STRING;
BEGIN
   Str0CardInt:={$IFDEF DOS} Str0Long {$ELSE} Str0Int64 {$ENDIF} (n,anz);
END;

PROCEDURE Log(kategorie:CHAR; LN:LONGINT; kommentar:STRING);
BEGIN
   CASE upcase(fortschritt) OF
   ' '     : EXIT;
   'A'     : ;
   'F','S' : IF (kategorie<>fortschritt) AND (kategorie<>'A') THEN EXIT;
   ELSE      EXIT
   END;
   IF LN=0 THEN Write(kommentar) ELSE WriteLN(kommentar);
END;

PROCEDURE Log2(kategorie:CHAR; LN:LONGINT; kommentar:STRING);
BEGIN
   IF TimeOut>0 THEN BEGIN
      stop0:=Intervall_Stop; Differenz_Moment;
      IF Diff_Moment.rminute>TimeOut THEN BEGIN
         Log('A',1,'QSORT   '+start0+'   '+stop0);
         Log('A',1,'QSORT   TimeOut.   Zeilen:'+StrCardInt(alle)+'   '+Intervall_Dauer);
         HALT;
      END;
   END;
   Log(kategorie,LN,kommentar);
END;

PROCEDURE HILFE(Seite:BYTE);
BEGIN
   IF Seite<=1 THEN BEGIN
      WriteLN; WriteLN(' '+VERSION_INFO); WriteLN;
      WriteLN(' QSORT [/Dn] [/Bn] [/R] [/+n] [/Ln] [/Pn] /Ieinfile /Oausfile'); WriteLN;
      WriteLN('  /R  ... reverse Sortierreihenfolge: ABSTEIGEND       (Standard: AUFSTEIGEND)');
      WriteLN('  /+n ... Sortieren nur ab(+) bzw. bis(-) Spalte n     (Standard: 1)');
      WriteLN('  /Ln ... max.Lnge der zu sortierenden Stze          (Standard: 133)');
      WriteLN('  /Pn ... Anzahl Puffer (auf Festplatte) 1..[15]..999  (Standard: 0)');
      WriteLN('  /Dn ... dynamische Pufferanzahl (berschreibt /P)    (Standard: AUS)');
      WriteLN('          n = Zeilen pro Puffer bei /D und /B          (Standard: ',StrCardInt(dynoptm),')');
      WriteLN('  /B  ... neues Verfahren (bin.Baum)                   (Standard: AUS)');
      WriteLN('          ber /Pn sind bis ',StrCardInt(blattmax),' Puffer zuweisbar',
              '':10-Length(StrCardInt(blattmax)),'(Standard: ',StrCardInt(blattoptm),')');
      WriteLN('          oder /Dn mglichst nicht zu kleines n        (Maximal:  ',StrCardInt(dynlaenge),')');
      {$IFNDEF DOS} WriteLN('  /Mn ... Benutze n KB Speicher','':23,' (Standard: ALLES)'); {$ENDIF}
      WriteLN('  /Fn ... Funktionen: 0=ZHLE 1=TEILE 2=SORT 4=MERGE   (Standard: 7 = alle)');
      WriteLN('  /Idn... Eingabedatei (ohne wre < Umleitung mglich,  Standard: INPUT)');
      WriteLN('  /Odn... Ausgabedatei (ohne wre > Umleitung mglich,  Standard: OUTPUT)');
      WriteLN('  /Zn ... Sortiere nur max. n Zeilen der Eingabe       (Standard: ALLE)');
      WriteLN('  /G  ... Unterscheide Gro/Kleinbuchstaben NICHT      (Standard: UNTERSCH.)');
      IF Seite=1 THEN BEGIN
         WriteLN('  /Y  ... Dummy-Schalter (siehe Seite 5)');
         WriteLN('  /H  ... (komplette) HILFE anzeigen!');
      END;
      WriteLN;
   END;
   IF Seite=2 THEN BEGIN
      WriteLN('  /Uf ... Name der temporren Bestnde                 (Standard: _TEMP_)');
      WriteLN('  /En ... Index des ersten temporren Bestands         (Standard: 1)');
      WriteLN('  /V  ... Nutze das TEMP-Verzeichnis (nur bis /P15)    (Standard: NICHT)');
      WriteLN('  /W  ... temporre Bestnde nicht lschen             (Standard: LSCHEN)');
      WriteLN('  /Xn ... Zeilen am Anfang berlesen                   (Standard: KEINE)');
      WriteLN('  /Nn:mR  Teil-Key Numerisch n-m, ABsteigend           (Standard: GESAMT-KEY)');
      WriteLN('  /Sn:mG  Teil-Key String n-m, AUFsteigend, NICHT G/k  (Standard: GESAMT-KEY)');
      WriteLN('  /Kfn... Keine Duplicate Keys (schreibe in Datei)     (Standard: AUS)');
      WriteLN('  /Q[F/A] Fortschrittsanzeige [Nichts/nur File/Alles]  (Standard: Sorts)');
      WriteLN('  /A  ... verhindert Wiederanlaufversuch               (Standard: AUS)');
      WriteLN('  /Tn ... Time Out nach n Minuten 1..999               (Standard: AUS)');
      WriteLN;
   END;
   IF Seite=3 THEN BEGIN
      WriteLN('  Die besten Ergebnisse werden erreicht:');
      WriteLN('  1.ohne Parameter/Pufferspeicher -> nur im Hauptspeicher');
      WriteLN('  2.mit Parameter /D ohne n fr Verfahren 2 mit bis zu 999 Puffern');
      WriteLN('  3.mit Parameter /B ohne n fr Verfahren 3 mit bis zu ',StrCardInt(blattoptm),' Puffern');
      WriteLN('    (bin.Baum) eventuell etwas langsamer');
      WriteLN;
      WriteLN('  Vorsicht!!! bei zu kleinem /Dn... sowie bei der Kombination /D /B');
      WriteLN;
      WriteLN('  Luft das Programm im Verfahren 1 oder 2 (keine Puffer oder /D ohne n),');
      WriteLN('  UND ist ber /I eine Eingabedatei angegeben, so wird vor einem eventuellen');
      WriteLN('  Abbruch wegen zu wenig Speicher erst noch das /B Verfahren (3) probiert!');
      WriteLN('  Verhindert werden kann dies allerdings durch Setzen des /A Paramters.');
      WriteLN;
   END;
   IF Seite=4 THEN BEGIN
      WriteLN('  Beispiele:');
      WriteLN('  QSORT /IEingabepfad /OAusgabepfad');
      WriteLN('  -> sortiert im Hauptspeicher ohne Puffer von Eingabe nach Ausgabe');
      WriteLN('     bei Abbruch wird noch der bin.Baum probiert (geht dann meistens).');
      WriteLN;
      WriteLN('  QSORT /P15 /Q < Eingabe > Ausgabe');
      WriteLN('  -> sortiert von Eingabe nach Ausgabe (Datei-Umleitung!).');
      WriteLN('     Es werden genau! 15 Puffer benutzt, Verfahren 1.');
      WriteLN('     (Achtung, es werden vorher die Zeilen gezhlt, geringfgig lnger)');
      WriteLN('     Keine Fortschrittsanzeige.');
      WriteLN;
      WriteLN('  QSORT /D /QA < Eingabe /OAusgabepfad /R /-10');
      WriteLN('  -> sortiert die (umgeleitete) Eingabe nach Ausgabe.');
      WriteLN('     Verfahren 1 mit bis zu 999 Puffern (je 1 Mio Zeilen).');
      WriteLN('     Umgekehrte Sortierfolge und Key nur Zeichen 1-10.');
      WriteLN('     Fortschrittsanzeige vollstndig, Files+Sort-Operationen.');
      WriteLN;
   END;
   IF Seite=5 THEN BEGIN
      WriteLN('  Hinweis: Parameter /Y hat keine spezielle Funktion, wird aber gebraucht,');
      WriteLN('  wenn man NUR die < und/oder > umgeleitete Ein-/Ausgabe sortieren mchte,');
      WriteLN('  ohne weitere Parameter (man vermeidet die Hilfe-Seite :-)');
      WriteLN;
   END;
END;

PROCEDURE PARAMETER;
PROCEDURE NochNicht(funktion:CHAR);
BEGIN
   WriteLN('Funktion ',funktion,' ist noch nicht implementiert!'); WriteLN;
   HALT;
END;
VAR i,dynneu: LONGINT;
    j: CARDINT;
    k: INTEGER;
    buffneu: BOOLEAN;
    p,tname: STRING;
BEGIN
   IF (PARAMCOUNT=0) THEN BEGIN
      HILFE(1); HALT
   END;
   buffneu:=FALSE; dynneu:=0;
   FOR i:=1 TO PARAMCOUNT DO BEGIN
      p:=PARAMSTR(i); VAL(COPY(p,3,255),j,k); tname:=COPY(p,3,255);
      IF p[1] IN ['/','-'] THEN
        CASE upcase(p[2]) OF
         '?','H': BEGIN
                 HILFE(0);
                 WriteLN(' Weiter mit Taste'); TasteDummy; WriteLN;
                 HILFE(2);
                 WriteLN(' Weiter mit Taste'); TasteDummy; WriteLN;
                 HILFE(3);
                 WriteLN(' Weiter mit Taste'); TasteDummy; WriteLN;
                 HILFE(4);
                 WriteLN(' Weiter mit Taste'); TasteDummy; WriteLN;
                 HILFE(5); HALT;
              END;
         'R': reverse:=TRUE;
         '+': IF (j>0) AND (j<=keylang) THEN abspalte:=j;
         '-': IF (j>0) AND (j<=keylang) THEN bisspalte:=j;
         'L': IF (j>0) AND (j<=255) THEN keylang:=j;
         'P': BEGIN
                 IF k<>0 THEN buffermax:=15;
                 IF (k=0) AND (j>=0) THEN BEGIN
                    IF j>blattmax THEN j:=blattmax;
                    buffermax:=j; buffneu:=TRUE;
                 END
              END;
         'D': BEGIN
                 bufferdyn:=TRUE;
                 IF (k=0) AND (j>0) THEN BEGIN
                    IF j>dynlaenge THEN j:=dynlaenge;
                    dynneu:=j;
                 END
              END;
         'B': baumalgo:=TRUE;
         'U': IF tname<>'' THEN tempbest:=tname;
         'V': BEGIN
                 tempverz:=GetEnv('TEMP');
                 IF tempverz='' THEN tempverz:=GetEnv('TMP');
              END;
         'W': temploes:=FALSE;
         'E': IF (j>0) AND (j<=999) THEN temperst:=j;
         'F': IF (j>=0) AND (j<=7) THEN funktion:=j;
         'I': IF tname<>'' THEN einname:=tname;
         'O': IF tname<>'' THEN ausname:=tname;
         'Z': IF (j>0) THEN BEGIN zeilenmax:=j; zaehlen:=FALSE; END;
         'A': versuchja:=FALSE;
         'G': grossklein:=FALSE;
         'T': IF (j>0) AND (j<=999) THEN timeout:=j;
         'Q': BEGIN
                 fortschritt:=' ';
                 IF upcase(tname[1])='S' THEN fortschritt:='S';
                 IF upcase(tname[1])='F' THEN fortschritt:='F';
                 IF upcase(tname[1])='A' THEN fortschritt:='A';
              END;
         {$IFNDEF DOS} 'M': IF (j>0) AND (j<=1024*1024) THEN memonutz:=j; {$ENDIF}
         'N': NochNicht('N');
         'S': NochNicht('S');
         'K': NochNicht('K');
         'X': NochNicht('X');
      END;
   END;
   dynlaenge:=dynoptm;
   IF dynneu>0 THEN dynlaenge:=dynneu;
   IF baumalgo THEN BEGIN
      blattmax:=blattoptm;
      IF buffneu THEN blattmax:=buffermax;
   END
   ELSE BEGIN
      IF buffermax>999 THEN buffermax:=999;
      IF temperst+buffermax-1>999 THEN HALT;
      IF bufferdyn THEN BEGIN;
         IF funktion MOD 2 = 0
            THEN bufferdyn:=FALSE
            ELSE BEGIN temperst:=1; buffermax:=1; END;
      END
   END;
   IF (fortschritt<>' ') AND (ausname='') THEN fortschritt:=' ';
   IF fortschritt='S' THEN SortLn:=1;
END;

FUNCTION VERGL_S(VAR a,b: STRING):BOOLEAN;
VAR s,i,l: LONGINT;
    erg:BOOLEAN; ac,bc:BYTE;
BEGIN
   i:=abspalte; s:=0;
   l:=LENGTH(a); IF l > LENGTH(b) THEN l:=LENGTH(b);
   IF l > bisspalte THEN l:=bisspalte;
   WHILE (s = 0) AND (i <= l) DO BEGIN
      IF grossklein
         THEN BEGIN ac:=ORD(a[i]); bc:=ORD(b[i]) END
         ELSE BEGIN ac:=ORD(UPCASE(a[i])); bc:=ORD(UPCASE(b[i])) END;
      IF ac < bc THEN s:=-1 ELSE
      IF ac > bc THEN s:=1;
      INC(i);
   END;
   CASE s OF
    -1: erg:=TRUE;
     1: erg:=FALSE;
     0: erg:=LENGTH(a) <= LENGTH(b)
   END;
   VERGL_S:=erg; IF reverse THEN VERGL_S:=NOT erg;
END;

FUNCTION VERGL(a,b: SCHLUESSEL):BOOLEAN;
BEGIN
   stra:=STRPAS(a); strb:=STRPAS(b);
   VERGL:=VERGL_S(stra,strb);
END;

PROCEDURE SWAP(p1,p2: ZEIGER);
VAR hilfe:SCHLUESSEL;
BEGIN
   hilfe:=p2^.key;
   p2^.key:=p1^.key;
   p1^.key:=hilfe;
END;

PROCEDURE QUICK(plinks,prechts: ZEIGER);
VAR p1,p2,p0: ZEIGER; pivot: SCHLUESSEL;
BEGIN
   IF plinks<>prechts THEN BEGIN
      p1:=plinks; p2:=plinks; p0:=plinks;
      pivot:=plinks^.key;
      REPEAT
         p2:=p2^.link;
         IF VERGL(p2^.key,pivot) THEN BEGIN
            p0:=p1; p1:=p1^.link;
            SWAP(p1,p2);
         END;
      UNTIL p2=prechts;
      SWAP(plinks,p1);
      IF p1<>prechts THEN p1:=p1^.link;
      QUICK(plinks,p0); QUICK(p1,prechts);
   END;
END;

FUNCTION FUNK_ERLAUBT(funktion,code: BYTE):BOOLEAN;
BEGIN
   CASE code OF
      TEILE:    FUNK_ERLAUBT:=funktion IN [1,3,5,7];
      SORTIERE: FUNK_ERLAUBT:=funktion IN [2,3,6,7];
      MISCHE:   FUNK_ERLAUBT:=funktion IN [4..7];
   END;
END;

FUNCTION All_EOF(buffer: LONGINT):BOOLEAN;
VAR d: LONGINT;
BEGIN
   d:=1; WHILE (d<=buffer) AND NOT datei[d].io DO INC(d);
   All_EOF:=(d>buffer);
END;

PROCEDURE READDATEI(dn: LONGINT);
BEGIN
   datei[dn].io:=NOT EOF(datei[dn].name);
   IF datei[dn].io THEN ReadLN(datei[dn].name,datei[dn].zeile);
END;

PROCEDURE Datei_Namen(buffervon,bufferbis,start: LONGINT; mitTemp: BOOLEAN);
VAR d: LONGINT;
    fname: STRING;
BEGIN
   FOR d:=buffervon TO bufferbis DO BEGIN
      fname:=COPY(tempbest,1,8)+'.'+Str0CardInt(d-buffervon+start+temperst-1,3);
      IF mitTEMP AND (tempverz<>'') THEN BEGIN
         IF fname[2]=':' THEN
            IF fname[3]='\'
               THEN fname:=COPY(fname,4,255)
               ELSE fname:=COPY(fname,3,255);
         fname:=tempverz+'\'+fname;
      END;
      ASSIGN(datei[d].name,fname);
      {$IFNDEF DOS}
      SetBufferAndNoFlush(datei[d].name,datei[d].buf,FALSE);
      {$ENDIF}
   END;
END;

FUNCTION Zahl_Erlaubt(von,bis: LONGINT; VAR zahl,hundert,zehn,eins: LONGINT):BOOLEAN;
BEGIN
   zahl:=bis-von+1;
   hundert:=zahl DIV 100;
   zehn:=(zahl MOD 100) DIV 10;
   eins:=zahl MOD 10;
   zahl_erlaubt:=TRUE;
   IF (von <1)  OR  (von >999) OR
      (bis <1)  OR  (bis >999) OR
      (zahl<1)  OR  (zahl>999) OR
      (von>bis) OR (bis+temperst-1>999)
   THEN zahl_erlaubt:=FALSE
END;

PROCEDURE INCRSTRING(VAR fname: STRING16; von,bis: STRING16);
VAR fzahl,d0,d1,p1: LONGINT;
    cc: STRING16;
    k:INTEGER;
BEGIN
   p1:=POS('.',fname);
   VAL(COPY(fname,p1+1,3),fzahl,k);
   IF k=0 THEN fname:=COPY(fname,1,p1)+Str0CardInt(fzahl+1,3)
   ELSE BEGIN
      FOR d0:=1 TO 3 DO
         IF COPY(von,p1+d0,1)<>COPY(bis,p1+d0,1) THEN k:=d0;
      cc:=COPY(fname,p1+k,1);
      FOR d1:=8 DOWNTO 0 DO
         IF cc=feld[d1] THEN cc:=feld[d1+1];
      fname:=COPY(fname,1,p1+k-1)+cc+COPY(fname,p1+k+1,3-k);
   END;
END;

PROCEDURE Fehler_Fall(Ursache:BYTE; Zahl:LONGINT); FORWARD;
(* Fehler_Meldung knnte auch direkt aufgerufen werden (z.Zt. kein Fall mehr) *)
PROCEDURE Fehler_Meldung(Ursache:BYTE; Zahl:LONGINT);
BEGIN
   WriteLN; WriteLN('  Speicherprobleme!!!'); WriteLN;
   CASE URSACHE OF
    {$IFNDEF DOS}
    1: WriteLN('  NEW-Anforderung ergibt NIL');
    2: WriteLN('  STRNEW-Anforderung ergibt NIL');
    3: WriteLN('  HEAP-Grenze erreicht! CurrHeapSize > ',StrCardInt(Zahl));
    4: WriteLN('  HEAP-Grenze erreicht! CurrHeapUsed > ',StrCardInt(Zahl));
    5: WriteLN('  HEAP-Grenze erreicht! CurrHeapFree < ',StrCardInt(Zahl));
    {$ELSE} 0: WriteLN('  MEMAVAIL zu gering (16bit) : ',MEMAVAIL); {$ENDIF}
   END;
   {$IFNDEF DOS}
   IF memonutz>0 THEN WriteLN(' Warum wurde /M',memonutz,' benutzt?');
   HeapStatusFPC:=GetFPCHeapStatus;
   WriteLN; WriteLN('  HEAP Gre: ',StrCardInt(HeapStatusFPC.CurrHeapSize),
                    '   Benutzt: ',StrCardInt(HeapStatusFPC.CurrHeapUsed),
                    '   Frei: ',StrCardInt(HeapStatusFPC.CurrHeapFree));
   {$ENDIF}
   WriteLN; WriteLN('  Versuche krzere Satzlnge oder',
                    ' mehr/kleinere Pufferspeicher');
   WriteLN; HILFE(3);
   HALT;
END;

PROCEDURE EING(VAR datei: TEXT; VAR anker: ZEIGER; maximal:CARDINT);
VAR akt,temp: ZEIGER;
    str0: STRING;
    pch0: ARRAY[0..255] OF CHAR;
BEGIN
   {$IFDEF DOS} MARK(heap); {$ENDIF}
   anker:=NIL; endeanker:=NIL; temp:=NIL; anzahl:=1;
   WHILE (NOT EOF(datei)) AND (anzahl<=maximal) DO BEGIN
      {$IFDEF DOS} IF MEMAVAIL < 500 THEN BEGIN Fehler_Fall(0,0); EXIT END;{$ENDIF}
      NEW(akt);
      {$IFNDEF DOS}
      IF akt=NIL THEN BEGIN Fehler_Fall(1,0); EXIT END;
      HeapStatusFPC:=GetFPCHeapStatus;
      IF memonutz>0 THEN
         IF HeapStatusFPC.CurrHeapUsed>=memonutz*1024 THEN BEGIN
            Fehler_Fall(4,memonutz*1024);
            EXIT;
      END;
      {$ENDIF}
      ReadLn(datei,str0); str0:=COPY(str0,1,keylang); INC(anzahl); INC(alle);
      IF str0<>'' THEN BEGIN
         STRPCOPY(pch0,str0); akt^.key:=STRNEW(pch0);
         {$IFNDEF DOS} IF akt^.key=NIL THEN BEGIN Fehler_Fall(2,0); EXIT END;{$ENDIF}
      END
      ELSE akt^.key:=CHR(0);
      IF anker=NIL THEN anker:=akt ELSE temp^.link:=akt;
      temp:=akt; endeanker:=akt;
   END;
   IF anker<>NIL THEN akt^.link:=NIL;
   IF alle>10000000 THEN punktaus:=alle DIV 10;
END;

PROCEDURE AUSG(VAR datei: TEXT; VAR anker: ZEIGER);
VAR hilfe: ZEIGER;
BEGIN
   hilfe:=anker;
   WHILE hilfe<>NIL DO BEGIN
      WriteLN(datei,STRPAS(hilfe^.key));
      hilfe:=hilfe^.link;
   END;
   {$IFDEF DOS} RELEASE(heap);
   {$ELSE}
   WHILE anker<>NIL DO BEGIN
      hilfe:=anker; anker:=anker^.link;
      IF LENGTH(STRPAS(hilfe^.key))>0 THEN DISPOSE(hilfe^.key);
      DISPOSE(hilfe);
   END;
   {$ENDIF}
END;

FUNCTION MERGE(buffer: LONGINT):STRING;
VAR d0,d1,d2: LONGINT;
BEGIN
   d0:=1; WHILE (d0<=buffer) AND NOT datei[d0].io DO INC(d0);
   zeile0:=datei[d0].zeile; d1:=d0+1;
   FOR d2:=d1 TO buffer DO IF datei[d2].io THEN
      IF VERGL_S(datei[d2].zeile,zeile0) THEN BEGIN
         d0:=d2; zeile0:=datei[d2].zeile;
   END;
   MERGE:=zeile0;
   INC(mischanzahl);
   READDATEI(d0);
END;

PROCEDURE LESE_DYN(VAR buffermax: LONGINT);
VAR str0: STRING;
BEGIN
   anzahl:=1;
   Datei_Namen(1,1,buffermax,FALSE);
   IF einok THEN EOF2:=EOF(eindatei) ELSE EOF2:=EOF(input);
   IF NOT EOF2 THEN BEGIN
      REWRITE(datei[1].name);
      Log('F',0,'OPEN/W  TMP('+StrCardInt(buffermax)+')  ');
   END;
   Log2('S',0,'TEILE TMP('+StrCardInt(buffermax)+') ...');
   WHILE NOT EOF2 DO BEGIN;
      IF einok THEN ReadLN(eindatei,str0) ELSE ReadLN(str0);
      IF einok THEN EOF2:=EOF(eindatei) ELSE EOF2:=EOF(input);
      INC(anzahl); IF anzahl>zeilenmax THEN EOF2:=TRUE;
      WriteLN(datei[1].name,str0);
      IF (NOT EOF2) AND ((anzahl-1) MOD dynlaenge = 0) AND (buffermax<999) THEN BEGIN
         Log('S',SortLn,' beendet  Zeilen:'+StrCardInt(anzahl-1)+'  ');
         CLOSE(datei[1].name); INC(buffermax);
         Log('F',1,'CLOSE/W TMP('+StrCardInt(buffermax-1)+')');
         Datei_Namen(1,1,buffermax,FALSE);
         REWRITE(datei[1].name);
         Log('F',0,'OPEN/W  TMP('+StrCardInt(buffermax)+')  ');
         Log2('S',0,'TEILE TMP('+StrCardInt(buffermax)+') ...');
      END;
   END;
   Log('S',SortLn,' beendet  Zeilen:'+StrCardInt(anzahl-1)+'  ');
   CLOSE(datei[1].name);
   Log('F',1,'CLOSE/W TMP('+StrCardInt(buffermax)+')');
END;

PROCEDURE MISCH_TOPF(buffer: LONGINT; von,bis,name: STRING16);
VAR d: LONGINT;
    fname: STRING16;
BEGIN
   IF POS('.',name)=LENGTH(name)-2 THEN name:=name+feld[0];
   fname:=von;
   FOR d:=1 TO buffer DO BEGIN
      ASSIGN(datei[d].name,fname); datei[d].fname:=fname;
      {$IFNDEF DOS}
      SetBufferAndNoFlush(datei[d].name,datei[d].buf,FALSE);
      {$ENDIF}
      RESET(datei[d].name);
      IF d=1 THEN Log('F',0,'OPEN/R  TMP');
      IF d=buffer
         THEN Log('F',1,'('+COPY(fname,Length(fname)-2,255)+')')
         ELSE Log('F',0,'('+COPY(fname,Length(fname)-2,255)+') ');
      READDATEI(d); INCRSTRING(fname,von,bis);
   END;
   IF COPY(name,LENGTH(name)-3,4)='.000' THEN BEGIN
      Log2('S',0,'MISCHE  TMP('+COPY(datei[1].fname,Length(datei[1].fname)-2,255));
      IF buffer<>1 THEN
         Log('S',0,') bis ('+COPY(datei[buffer].fname,Length(datei[buffer].fname)-2,255));
      Log('S',0,') -> Endbestand ('+ausname+') ...');
      REPEAT
         zeile1:=MERGE(buffer);
         IF ausok
            THEN WriteLN(ausdatei,zeile1)
            ELSE WriteLN(zeile1);
            IF mischanzahl MOD punktaus = 1 THEN Log('S',0,'.');
      UNTIL All_EOF(buffer);
      Log('S',1,' beendet  ');
   END
   ELSE BEGIN
      ASSIGN(datei[buffer+1].name,name);
      {$IFNDEF DOS}
      SetBufferAndNoFlush(datei[buffer+1].name,datei[buffer+1].buf,FALSE);
      {$ENDIF}
      REWRITE(datei[buffer+1].name);
      Log('F',1,'OPEN/W  TMP('+COPY(name,Length(name)-2,255)+')  ');
      Log2('S',0,'MISCHE  TMP('+COPY(datei[1].fname,Length(datei[1].fname)-2,255));
      IF buffer<>1 THEN
         Log('S',0,') bis ('+COPY(datei[buffer].fname,Length(datei[buffer].fname)-2,255));
      Log('S',0,') -> TMP('+COPY(name,Length(name)-2,255)+') ...');
      REPEAT
         WriteLN(datei[buffer+1].name,MERGE(buffer));
         IF mischanzahl MOD punktaus = 1 THEN Log('S',0,'.');
      UNTIL All_EOF(buffer);
      Log('S',1,' beendet  ');
      CLOSE(datei[buffer+1].name);
      Log('F',1,'CLOSE/W TMP('+COPY(name,Length(name)-2,255)+')');
   END;
   FOR d:=1 TO buffer DO BEGIN
      CLOSE(datei[d].name); IF temploes THEN ERASE(datei[d].name);
      fname:=datei[d].fname;
      IF d=1 THEN Log('F',0,'CLOSE/R TMP');
      IF d=buffer
         THEN Log('F',1,'('+COPY(fname,Length(fname)-2,255)+')')
         ELSE Log('F',0,'('+COPY(fname,Length(fname)-2,255)+') ');
   END;
END;

PROCEDURE MISCHEN(name: STRING16; von,bis: LONGINT);
VAR zahl,z100,z10,z1: LONGINT;
    ii,von_neu,bis_neu: LONGINT;
    name0: STRING16;
BEGIN
   IF NOT Zahl_Erlaubt(von,bis,zahl,z100,z10,z1) THEN EXIT;
   IF zahl = 100 THEN BEGIN
      FOR ii:=0 TO 9 DO BEGIN
         von_neu:=von+ii*10;
         bis_neu:=von_neu+9;
         MISCHEN(name+feld[ii],von_neu,bis_neu);
      END;
      MISCH_TOPF(10,name+feld[0],name+feld[9],name+'0');
      EXIT;
   END ELSE
   IF zahl > 100 THEN BEGIN;
      FOR ii:=0 TO z100 DO BEGIN
         von_neu:=von+ii*100;
         IF ii=z100
           THEN bis_neu:=von_neu+z10*10+z1-1
           ELSE bis_neu:=von_neu+99;
         MISCHEN(name+feld[ii],von_neu,bis_neu);
      END;
      name0:=name+feld[z100];
      IF (zahl MOD 100) > 0 THEN
         IF z1=0
            THEN MISCH_TOPF(z10,name0+feld[0],name0+feld[z10-1],name0+'0')
            ELSE MISCH_TOPF(z10+1,name0+feld[0],name0+feld[z10],name0+'0');
      EXIT;
   END ELSE
   IF zahl > 10 THEN BEGIN;
      FOR ii:=0 TO z10 DO BEGIN
         von_neu:=von+ii*10;
         IF ii=z10
            THEN bis_neu:=von_neu+z1-1
            ELSE bis_neu:=von_neu+9;
         MISCHEN(name+feld[ii],von_neu,bis_neu);
      END;
      EXIT;
   END ELSE
   MISCH_TOPF(bis-von+1,COPY(name,1,POS('.',name))+Str0CardInt(von+temperst-1,3),
              COPY(name,1,POS('.',name))+Str0CardInt(bis+temperst-1,3),name);
END;

PROCEDURE MISCHE_1699(name: STRING16; von,bis: LONGINT);
VAR zahl,z100,z10,z1: LONGINT;
    name0: STRING16;
BEGIN
   IF NOT Zahl_Erlaubt(von,bis,zahl,z100,z10,z1) THEN EXIT;
   name:=name+'0';
   IF bis-von<100 THEN name:=name+'0';
   IF bis-von<10 THEN name:=name+'0';
   MISCHEN(name,von,bis);
   name0:=name+feld[0];
   IF zahl > 100 THEN
      IF zahl MOD 100 = 0
         THEN MISCH_TOPF(z100,name0+'0',name+feld[z100-1]+'0',name+'00')
         ELSE MISCH_TOPF(z100+1,name0+'0',name+feld[z100]+'0',name+'00')
   ELSE
   IF (zahl > 10) AND (zahl <> 100) THEN
      IF zahl MOD 10 = 0
         THEN MISCH_TOPF(z10,name0,name+feld[z10-1],name+'0')
         ELSE MISCH_TOPF(z10+1,name0,name+feld[z10],name+'0')
END;

PROCEDURE TEILE_1699(buffer: LONGINT);
VAR str0: STRING;
    norm,kk_add,jj_ext,zz_n: LONGINT;
    zz_sum: CARDINT;
BEGIN
   zz_sum:=0;
   IF einok THEN BEGIN
      IF zaehlen THEN BEGIN
         WHILE (NOT EOF(eindatei)) AND (zz_sum<zeilenmax) DO BEGIN;
            ReadLN(eindatei,str0); zz_sum:=zz_sum+1;
         END;
         CLOSE(eindatei);
         Log('F',1,'CLOSE/R '+einname+' (wegen Zhlen)');
         RESET(eindatei);
         Log('F',1,'OPEN/R  '+einname+' (gezhlt)');
      END
      ELSE zz_sum:=zeilenmax;
   END
   ELSE BEGIN
      Datei_Namen(1,1,-temperst+1,FALSE);
      IF zaehlen THEN BEGIN
         REWRITE(datei[1].name);
         Log('F',1,'OPEN/W  DUMMY (wegen Zhlen)');
         WHILE (NOT EOF) AND (zz_sum<zeilenmax) DO BEGIN;
            ReadLN(str0); WriteLN(datei[1].name,str0); zz_sum:=zz_sum+1;
         END;
         CLOSE(datei[1].name);
         Log('F',1,'CLOSE/W DUMMY (wegen Zhlen)');
         RESET(datei[1].name);
         Log('F',1,'OPEN/R  DUMMY (gezhlt)');
      END
      ELSE zz_sum:=zeilenmax;
   END;
   Datei_Namen(2,2,1,FALSE); REWRITE(datei[2].name);
   Log('F',1,'OPEN/W  TMP(1)');
   IF zz_sum < buffermax THEN buffermax:=zz_sum;
   IF zz_sum > buffermax
      THEN norm:=zz_sum DIV buffermax
      ELSE norm:=1;
   kk_add:=zz_sum MOD buffermax;
   jj_ext:=1; zz_n:=0; anzahl:=1;
   IF einok THEN EOF2:=EOF(eindatei)
   ELSE
      IF zaehlen THEN EOF2:=EOF(datei[1].name) ELSE EOF2:=EOF(input);
      Log2('S',0,'TEILE TMP('+StrCardInt(jj_ext)+') ...');
      WHILE (NOT EOF2) AND (jj_ext<=buffermax) AND (anzahl<=zeilenmax) DO BEGIN;
      INC(zz_n);
      IF ((zz_n > norm+1) AND (jj_ext <= kk_add) OR
          (zz_n > norm)   AND (jj_ext >  kk_add))     THEN BEGIN
         zz_n:=1;
         INC(jj_ext); IF jj_ext>buffermax THEN jj_ext:=1;
         Log('S',SortLn,' beendet  Zeilen:'+StrCardInt(anzahl-1)+'  ');
         CLOSE(datei[2].name);
         Log('F',0,'CLOSE/W TMP('+StrCardInt(jj_ext-1)+')  ');
         Datei_Namen(2,2,jj_ext,FALSE);
         REWRITE(datei[2].name);
         Log('F',1,'OPEN/W  TMP('+StrCardInt(jj_ext)+')');
         Log2('S',0,'TEILE TMP('+StrCardInt(jj_ext)+') ...');
      END;
      IF einok THEN BEGIN ReadLN(eindatei,str0); EOF2:=EOF(eindatei); END
      ELSE
         IF zaehlen
            THEN BEGIN ReadLN(datei[1].name,str0); EOF2:=EOF(datei[1].name); END
            ELSE BEGIN ReadLN(str0); EOF2:=EOF(input); END;
      WriteLN(datei[2].name,str0); anzahl:=anzahl+1;
   END;
   Log('S',SortLn,' beendet  Zeilen:'+StrCardInt(anzahl-1)+'  ');
   CLOSE(datei[2].name);
   Log('F',1,'CLOSE/W TMP('+StrCardInt(jj_ext)+')');
   IF einok THEN BEGIN
      CLOSE(eindatei);
      Log('F',1,'CLOSE/R '+einname+' (gezhlt)');
   END
   ELSE
      IF zaehlen THEN BEGIN
         CLOSE(datei[1].name); ERASE(datei[1].name);
         Log('F',1,'CLOSE/R DUMMY (gezhlt)');
      END;
END;

PROCEDURE SORT_15(buffer: LONGINT);
VAR d: LONGINT;
BEGIN
   Datei_Namen(1,buffer,1,TRUE);
   IF FUNK_ERLAUBT(funktion,TEILE) AND NOT bufferdyn THEN BEGIN;
      FOR d:=1 TO buffer DO BEGIN
         REWRITE(datei[d].name);
         IF d=1 THEN Log('F',0,'OPEN/R  TMP');
         IF d=buffer
            THEN Log('F',1,'('+StrCardInt(d)+')')
            ELSE Log('F',0,'('+StrCardInt(d)+') ');
      END;
      d:=1; anzahl:=1;
      Log2('S',0,'TEILE TMP(1');
      IF buffer<>1 THEN Log('S',0,') bis ('+StrCardInt(buffer));
      Log('S',0,') ...');
      IF einok THEN
         REPEAT
            ReadLN(eindatei,zeile0);
            WriteLN(datei[d].name,zeile0); INC(anzahl);
            IF d = buffer THEN d:=1 ELSE INC(d);
            IF anzahl MOD punktaus = 1 THEN Log('S',0,'.');
         UNTIL EOF(eindatei) OR (anzahl>zeilenmax)
      ELSE
         REPEAT
            ReadLN(zeile0);
            WriteLN(datei[d].name,zeile0); INC(anzahl);
            IF d = buffer THEN d:=1 ELSE INC(d);
            IF anzahl MOD punktaus = 1 THEN Log('S',0,'.');
        UNTIL EOF OR (anzahl>zeilenmax);
      Log('S',1,' beendet  Zeilen:'+StrCardInt(anzahl-1)+'  ');
      FOR d:=1 TO buffer DO BEGIN
         CLOSE(datei[d].name);
         IF d=1 THEN Log('F',0,'CLOSE/R TMP');
         IF d=buffer
            THEN Log('F',1,'('+StrCardInt(d)+')')
            ELSE Log('F',0,'('+StrCardInt(d)+') ');
      END;
   END;
   buffer:=buffermax;
   IF FUNK_ERLAUBT(funktion,SORTIERE) THEN
      FOR d:=1 TO buffer DO BEGIN
         RESET(datei[d].name);
         Log('F',0,'OPEN/R  TMP('+StrCardInt(d)+')  ');
         EING(datei[d].name,anker,MAXCARD);
         IF NOT fehlerfrei THEN EXIT;
         CLOSE(datei[d].name);
         Log('F',0,'CLOSE/R  ');
         Log2('S',0,'SORT TMP('+StrCardInt(d)+') ...');
         QUICK(anker,endeanker);
         Log('S',SortLn,' beendet  ');
         REWRITE(datei[d].name);
         Log('F',0,'OPEN/W  ');
         AUSG(datei[d].name,anker);
         CLOSE(datei[d].name);
         Log('F',1,'CLOSE/W  TMP('+StrCardInt(d)+')');
   END;
   buffer:=buffermax;
   IF FUNK_ERLAUBT(funktion,MISCHE) THEN BEGIN;
      FOR d:=1 TO buffer DO BEGIN
         RESET(datei[d].name); READDATEI(d);
         IF d=1 THEN Log('F',0,'OPEN/R  TMP');
         IF d=buffer
            THEN Log('F',1,'('+StrCardInt(d)+')')
            ELSE Log('F',0,'('+StrCardInt(d)+') ');
      END;
      Log2('S',0,'MISCHE TMP(1');
      IF buffer>1 THEN Log('S',0,') bis ('+StrCardInt(buffer));
      Log('S',0,') -> Endbestand ('+ausname+') ...');
      REPEAT
         zeile1:=MERGE(buffer);
         IF ausok
            THEN WriteLN(ausdatei,zeile1)
            ELSE WriteLN(zeile1);
         IF mischanzahl MOD punktaus = 1 THEN Log('S',0,'.');
      UNTIL All_EOF(buffer);
      Log('S',1,' beendet  ');
      FOR d:=1 TO buffer DO BEGIN
         CLOSE(datei[d].name); IF temploes THEN ERASE(datei[d].name);
         IF d=1 THEN Log('F',0,'CLOSE/R TMP');
         IF d=buffer
            THEN Log('F',1,'('+StrCardInt(d)+')')
            ELSE Log('F',0,'('+StrCardInt(d)+') ');
      END;
   END;
END;

PROCEDURE SORT_1699(buffer: LONGINT);
VAR d: LONGINT;
BEGIN
   IF FUNK_ERLAUBT(funktion,TEILE) AND NOT bufferdyn THEN BEGIN;
      TEILE_1699(buffer);
   END;
   buffer:=buffermax;
   IF FUNK_ERLAUBT(funktion,SORTIERE) THEN BEGIN;
      FOR d:=buffer DOWNTO 1 DO BEGIN
         Datei_Namen(1,1,d,FALSE); RESET(datei[1].name);
         Log('F',0,'OPEN/R  TMP('+StrCardInt(d)+')  ');
         EING(datei[1].name,anker,MAXCARD);
         IF NOT fehlerfrei THEN EXIT;
         CLOSE(datei[1].name);
         Log('F',0,'CLOSE/R  ');
         Log2('S',0,'SORT TMP('+StrCardInt(d)+') ...');
         QUICK(anker,endeanker);
         Log('S',SortLn,' beendet  ');
         REWRITE(datei[1].name);
         Log('F',0,'OPEN/W  ');
         AUSG(datei[1].name,anker);
         CLOSE(datei[1].name);
         Log('F',1,'CLOSE/W TMP('+StrCardInt(d)+')');
      END;
   END;
   buffer:=buffermax;
   IF FUNK_ERLAUBT(funktion,MISCHE) THEN BEGIN;
      MISCHE_1699(tempbest+'.',1,buffer);
   END;
END;

PROCEDURE NUR_ZAEHLEN;
BEGIN
   zeilenzahl:=0;
   IF einok
      THEN WHILE (NOT EOF(eindatei)) AND (zeilenzahl<zeilenmax) DO BEGIN
         ReadLN(eindatei,zeile0); zeilenzahl:=zeilenzahl+1;
      END
      ELSE WHILE (NOT EOF(input)) AND (zeilenzahl<zeilenmax) DO BEGIN
         ReadLN(zeile0); zeilenzahl:=zeilenzahl+1;
      END;
   WriteLN('Anzahl:',zeilenzahl);
END;

PROCEDURE EINDATEI_OPEN;
BEGIN
   IF einname='' THEN BEGIN einok:=FALSE; {$I-} EOF2:=EOF(input) {$I+} END
   ELSE BEGIN
      einok:=TRUE; EOF2:=TRUE;
      ASSIGN(eindatei,einname);
      {$IFNDEF DOS}
      SetBufferAndNoFlush(eindatei,einbuf,FALSE);
      {$ENDIF}
      {$I-} RESET(eindatei); {$I+} IF IOResult<>0 THEN fileok:=FALSE;
      IF fileok THEN {$I-} EOF2:=EOF(eindatei) {$I+}
   END;
   IF (IOResult<>0) OR (NOT fileok) OR EOF2 THEN BEGIN HILFE(1); HALT END;
   IF einok THEN Log('F',1,'OPEN/R  '+einname) ELSE Log('F',1,'OPEN/R input');
END;

PROCEDURE AUSDATEI_OPEN;
BEGIN
   IF ausname='' THEN ausok:=FALSE
   ELSE BEGIN
      ausok:=TRUE;
      ASSIGN(ausdatei,ausname);
      {$IFNDEF DOS}
      SetBufferAndNoFlush(ausdatei,ausbuf,FALSE);
      {$ENDIF}
      {$I-} REWRITE(ausdatei); {$I+} IF IOResult<>0 THEN fileok:=FALSE;
   END;
   IF NOT fileok THEN BEGIN HILFE(1); HALT END;
   IF ausok THEN Log('F',1,'OPEN/W  '+ausname);
END;

PROCEDURE BLATT_NAMEN(blatt,dcb: LONGINT);
VAR fname: STRING;
BEGIN
   fname:=COPY(tempbest,1,8)+'.'+
   {$IFDEF DOS} StrHex {$ELSE} Str0CardInt {$ENDIF} (blatt,3);
   ASSIGN(datei[dcb].name,fname);
   {$IFNDEF DOS}
   SetBufferAndNoFlush(datei[dcb].name,datei[dcb].buf,FALSE);
   {$ENDIF}
END;

PROCEDURE BLATT_SORT(blatt: LONGINT);
BEGIN
   BLATT_NAMEN(baum[blatt].datei,1);
   RESET(datei[1].name);
   Log('F',0,'OPEN/R  TMP('+StrCardInt(baum[blatt].datei)+')  ');
   EING(datei[1].name,anker,MAXCARD);
   CLOSE(datei[1].name);
   Log('F',0,'CLOSE/R  ');
   Log2('S',0,'SORT TMP('+StrCardInt(baum[blatt].datei)+') ...');
   QUICK(anker,endeanker);
   Log('S',SortLn,' beendet  ');
   REWRITE(datei[1].name);
   Log('F',0,'OPEN/W  ');
   AUSG(datei[1].name,anker);
   CLOSE(datei[1].name);
   Log('F',1,'CLOSE/W TMP('+StrCardInt(baum[blatt].datei)+')');
END;

PROCEDURE BLATT_LOESCHE(blatt,dcb: LONGINT);
VAR tdatei:LONGINT;
BEGIN
   WITH baum[blatt] DO BEGIN
      tdatei:=datei; datei:=0; status:='L';
   END;
   CLOSE(datei[dcb].name);
   IF temploes THEN ERASE(datei[dcb].name);
   Log('F',0,'CLOSE/R TMP('+StrCardInt(tdatei)+')  ');
END;

FUNCTION BLATT_MERGE:STRING;
VAR d1: LONGINT;
BEGIN
   BLATT_MERGE:='';
   IF NOT (datei[2].io OR datei[3].io) THEN EXIT;
   IF datei[2].io AND datei[3].io
      THEN
         IF VERGL_S(datei[2].zeile,datei[3].zeile)
            THEN d1:=2 ELSE d1:=3
      ELSE
         IF datei[2].io THEN d1:=2 ELSE d1:=3;
   BLATT_MERGE:=datei[d1].zeile;
   READDATEI(d1);
   INC(mischanzahl);
END;

PROCEDURE BAUM_DYN;
VAR str0: STRING;
BEGIN
   blattanzahl:=1; anzahl:=1;
   BLATT_NAMEN(1,1);
   IF einok THEN EOF2:=EOF(eindatei) ELSE EOF2:=EOF(input);
   IF NOT EOF2 THEN BEGIN
      REWRITE(datei[1].name);
      Log('F',0,'OPEN/W  TMP('+StrCardInt(blattanzahl)+')  ');
   END;
   Log2('S',0,'TEILE TMP('+StrCardInt(blattanzahl)+') ...');
   WHILE NOT EOF2 DO BEGIN;
      IF einok THEN ReadLN(eindatei,str0) ELSE ReadLN(str0);
      IF einok THEN EOF2:=EOF(eindatei) ELSE EOF2:=EOF(input);
      INC(anzahl); IF anzahl>zeilenmax THEN EOF2:=TRUE;
      WriteLN(datei[1].name,str0);
      IF (NOT EOF2) AND ((anzahl-1) MOD blattlaenge = 0) AND (blattanzahl<blattmax) THEN BEGIN
         Log('S',SortLn,' beendet  Zeilen:'+StrCardInt(anzahl-1)+'  ');
         CLOSE(datei[1].name);
         Log('F',1,'CLOSE/W TMP('+StrCardInt(blattanzahl)+')');
         INC(blattanzahl); BLATT_NAMEN(blattanzahl,1);
         REWRITE(datei[1].name);
         Log('F',0,'OPEN/W  TMP('+StrCardInt(blattanzahl)+')  ');
         Log2('S',0,'TEILE TMP('+StrCardInt(blattanzahl)+') ...');
      END;
   END;
   Log('S',SortLn,' beendet  Zeilen:'+StrCardInt(anzahl-1)+'  ');
   CLOSE(datei[1].name);
   Log('F',1,'CLOSE/W TMP('+StrCardInt(blattanzahl)+')');
END;

PROCEDURE BAUM_MERGE(ziel,links,rechts: LONGINT);
BEGIN
   IF baum[links].datei<>1 THEN Log('F',1,'');
   IF links=0
      THEN datei[2].io:=FALSE
      ELSE BEGIN
         BLATT_NAMEN(baum[links].datei,2);
         RESET(datei[2].name); READDATEI(2);
         Log('F',0,'OPEN/R  TMP('+StrCardInt(baum[links].datei)+')  ');
   END;
   IF rechts=0
      THEN datei[3].io:=FALSE
      ELSE BEGIN
         BLATT_NAMEN(baum[rechts].datei,3);
         RESET(datei[3].name); READDATEI(3);
         Log('F',0,'OPEN/R  TMP('+StrCardInt(baum[rechts].datei)+')  ');
   END;
   IF ziel<>1
      THEN BEGIN
         BLATT_NAMEN(baum[ziel].datei,1);
         REWRITE(datei[1].name);
         Log('F',1,'OPEN/W  TMP('+StrCardInt(baum[ziel].datei)+')  ');
         Log2('S',0,'MISCHE  TMP('+StrCardInt(baum[links].datei)+') + TMP('+
                                  StrCardInt(baum[rechts].datei)+') -> TMP('+
                                  StrCardInt(baum[ziel].datei)+') ...');
         REPEAT
            WriteLN(datei[1].name,BLATT_MERGE);
            IF mischanzahl MOD punktaus = 1 THEN Log('S',0,'.');
         UNTIL (NOT datei[2].io) AND (NOT datei[3].io);
         Log('S',1,' beendet  ');
         CLOSE(datei[1].name);
         Log('F',0,'CLOSE/W TMP('+StrCardInt(baum[ziel].datei)+')  ');
      END
      ELSE BEGIN
         Log('F',1,'');
         Log2('S',0,'MISCHE  TMP('+StrCardInt(baum[links].datei));
         IF nureins=0
            THEN Log('S',0,') + TMP('+StrCardInt(baum[rechts].datei));
         Log('S',0,') -> Endbestand ('+ausname+') ...');
         REPEAT
            zeile1:=BLATT_MERGE;
            IF ausok
               THEN WriteLN(ausdatei,zeile1)
               ELSE WriteLN(zeile1);
            IF mischanzahl MOD punktaus = 1 THEN Log('S',0,'.');
         UNTIL (NOT datei[2].io) AND (NOT datei[3].io);
         Log('S',1,' beendet  ');
      END;
END;

PROCEDURE BAUM_MISCHE(blatt: LONGINT);
VAR kette: STRING[2];
BEGIN
   WITH baum[blatt] DO BEGIN
      kette:=baum[links].status+baum[rechts].status;
      IF (kette='SS') OR (kette='MS') OR (kette='SM') OR (kette='MM') THEN BEGIN
         datei:=blattmax+blatt; kette:='';
         status:='M';
         BAUM_MERGE(blatt,links,rechts);
         BLATT_LOESCHE(links,2); BLATT_LOESCHE(rechts,3);
      END;
      IF (kette='SL') OR (kette='ML') THEN BEGIN
         IF blatt<>1
            THEN datei:=baum[links].datei
            ELSE BEGIN
               BAUM_MERGE(blatt,links,0);
               BLATT_LOESCHE(links,2);
         END;
         status:='M'; kette:='';
      END;
      IF (kette='LS') or (kette='LM') THEN BEGIN
         IF blatt<>1
            THEN datei:=baum[rechts].datei
            ELSE BEGIN
               BAUM_MERGE(blatt,0,rechts);
               BLATT_LOESCHE(rechts,3);
         END;
         status:='M'; kette:='';
      END;
   END;
END;

PROCEDURE BAUM_STEUER(blatt: LONGINT);
BEGIN
   WITH baum[blatt] DO BEGIN
      IF (links=0) AND (rechts=0) THEN BEGIN
         (* SORT ist hier nicht mehr ntig *)
         EXIT;
      END;
      IF links  <> 0 then BAUM_STEUER(links);
      IF rechts <> 0 then BAUM_STEUER(rechts);
      BAUM_MISCHE(blatt);
   END;
END;

PROCEDURE Q_BAUM;
VAR d: LONGINT;
BEGIN
   IF baumfrei THEN BEGIN;
      baumfrei:=FALSE;
      aeste[1]:=1; FOR d:=2 TO 22 DO aeste[d]:=2*aeste[d-1];
      IF blattlaenge<dynlaenge THEN blattlaenge:=dynlaenge;
      IF FUNK_ERLAUBT(funktion,TEILE) THEN BAUM_DYN;
      FOR d:=21 DOWNTO 2 DO
         IF blattanzahl<=aeste[d] THEN BEGIN
           baumstart:=aeste[d];
           baumende:=aeste[d+1];
      END;
      {$IFNDEF DOS} SetLength(baum,baumende+1); {$ENDIF}
      IF blattanzahl=1 THEN nureins:=1;
      FOR d:=1 TO baumende DO WITH baum[d] DO
         IF d >= baumstart THEN BEGIN
            links:=0; rechts:=0;
            IF d < baumstart+blattanzahl
               THEN BEGIN datei:=d-baumstart+1; status:='S'; END
               ELSE BEGIN datei:=0; status:='L'; END
         END
         ELSE BEGIN
            links:=d*2; rechts:=links+1;
            datei:=0; status:='L';
      END;
      IF FUNK_ERLAUBT(funktion,SORTIERE)
         THEN FOR d:=1 TO blattanzahl DO BLATT_SORT(baumstart+d-1);
      IF FUNK_ERLAUBT(funktion,MISCHE) THEN BAUM_STEUER(1);
   END;
END;

PROCEDURE Fehler_Fall(Ursache:BYTE; Zahl:LONGINT);
VAR hilfe:ZEIGER;
BEGIN
   fehlerfrei:=FALSE; alle:=0;
   dynlaenge:=anzahl DIV 100 * 95;
   IF baumfrei AND versuchja
               AND (einname<>'') AND ((buffermax=0) OR bufferdyn) THEN BEGIN
      Log('S',1,'Speicherfehler?! Schalte um auf /B Verfahren');
      IF einok THEN BEGIN
         CLOSE(eindatei);
         Log('F',1,'CLOSE/R '+einname+' (Reset wegen Fehler)');
      END;
      EINDATEI_OPEN;
      IF ausok THEN BEGIN
         CLOSE(ausdatei);
         Log('F',1,'CLOSE/W '+ausname+' (Reset wegen Fehler)');
      END;
      AUSDATEI_OPEN;
      {$IFDEF DOS} RELEASE(heap);
      {$ELSE}
      HeapStatusFPC:=GetFPCHeapStatus;
      WHILE (HeapStatusFPC.CurrHeapUsed>200) AND (anker<>NIL) DO BEGIN
         hilfe:=anker; anker:=anker^.link;
         IF LENGTH(STRPAS(hilfe^.key))>0 THEN DISPOSE(hilfe^.key);
         DISPOSE(hilfe);
         HeapStatusFPC:=GetFPCHeapStatus;
      END;
      (* das Schicksal des letzten Listenelements beim Abbruch war unsicher,  *)
      (* daher wird das Stckchen HEAP hier aufgegeben                        *)
      anker:=NIL; endeanker:=NIL;
      {$ENDIF}
      Q_BAUM;
   END
   ELSE Fehler_Meldung(Ursache,zahl);
END;

BEGIN
   start0:=Intervall_Start;
   PARAMETER;
   {$IFNDEF DOS} ReturnNilIfGrowHeapFails:=TRUE; {$ENDIF}
   Log('A',1,VERSION_INFO);
   IF einname=''
      THEN Log('F',0,'Eingabe:INPUT')
      ELSE Log('F',0,'Eingabe:'+einname);
   Log('F',1,'   Ausgabe:'+ausname);
   EINDATEI_OPEN; AUSDATEI_OPEN;
   {$IFNDEF DOS}
   (* geht nicht: SetBufferAndNoFlush(input,inbuf,FALSE); *)
   IF NOT ausok THEN SetBufferAndNoFlush(output,outbuf,TRUE);
   {$ENDIF}
   IF funktion=0 THEN NUR_ZAEHLEN ELSE
   IF baumalgo THEN Q_BAUM
   ELSE BEGIN
      IF bufferdyn THEN LESE_DYN(buffermax);
      IF NOT fehlerfrei THEN GoTo QSE;
      CASE buffermax OF
       0:       BEGIN
                   IF einok
                      THEN EING(eindatei,anker,zeilenmax)
                      ELSE EING(input,anker,zeilenmax);
                   IF NOT fehlerfrei THEN GoTo QSE;
                   QUICK(anker,endeanker);
                   IF ausok
                      THEN AUSG(ausdatei,anker)
                      ELSE AUSG(output,anker);
                END;
       1..15:   SORT_15(buffermax);
       16..999: SORT_1699(buffermax);
      END;
   END;
QSE:
   IF ausok THEN CLOSE(ausdatei);
   Log('F',1,'CLOSE/W '+ausname);
   Log('F',1,'CLOSE/R '+einname);
   stop0:=Intervall_Stop;  Differenz_Moment;
   IF Diff_Moment.rminute>240 THEN Log('A',1,'QSORT   '+start0+'   '+stop0);
   Log('A',1,'QSORT   beendet.   Zeilen:'+StrCardInt(alle)+'   '+Intervall_Dauer);
   CLOSE(output); (* :-) *)
END (* QSort *).
