{$IFDEF DOS} {$N+} {$ENDIF}
UNIT Zeit;      (* (c) ALFWARE Bernd Schubert *)

interface

uses DOS, StdIO {$IFNDEF DOS} , SysUtils, DateUtils {$ENDIF};

type Moment = record
        wjahr, wmonat, wtag,
        wstunde, wminute, wsekunde,
        wmsek, wwotag                : word;
        jahr, monat, tag,
        stunde, minute, sekunde,
        msek, wotag                  : longint;
        abstag                       : longint;
        abssek                       : double;
{$IFDEF DOS}
        absMS                        : double;
{$ELSE}
        absDT                        : TDateTime;
        absTS                        : TTimeStamp;
        absMS                        : int64;
{$ENDIF}
        heute_feiertag               : integer;
        welcher_feiertag             : array [1..5] of string[30];
     end;

     DiffMoment = record
        ijahr, imonat, itag,
        istunde, iminute, isekunde,
        imsek                        : longint;
        rjahr, rmonat, rwoche,
        rtag, rstunde, rminute,
        rsekunde                     : double;
     end;

     FT_FELD = record
        ftJAHR,ftANZAHL              : longint;
        FT : array[ 1..50] of record
           ftNAME                    : string[30];
           nTAG, nMONAT,
           nIMJAHR, nWOTAG           : longint;
           nWOCHENTAG, nKETTE        : string[10];
           ftRANG                    : longint;
        end;
        HappyKadaver,
        Reformationstag,
        AlleHeimlichen,
        DreiKoenige                  : boolean;
     end;

var  Akt_Moment, Test_Moment         : Moment;
     Diff_Moment {$IFDEF DOS} , Summe_Moment {$ENDIF} :DiffMoment;

     Formate: record
        TT_MM_JJ, TT_MM_JJJJ,
        JJJJ_MM_TT, HH_MM_SS,
        HH_MM_SS_MS, Wochentag,
        Abs_MS, Abs_Tag,
        Timestamp, Ddatum,
        DdatumTzeit, Datum_Zeit      : string;
     end;

     Diff_TimeStamp, Diff_TimeStamp24 : string;
     {$IFDEF DOS} Summe_TimeStamp, Summe_TimeStamp24 : string; {$ENDIF}
     Diff_Einzel, Diff_ABS,
     Diff_Abs_Jahre, Diff_Abs_Monate,
     Diff_Abs_Wochen, Diff_Abs_Tage,
     Diff_Abs_Stunden, Diff_Abs_Minuten,
     Diff_Abs_Sekunden               : string;

     Feiertage: FT_FELD;

function StopUhr(Kommentar: string): string;
(* Neue StechUhr TimeStamp als Ausgabestring *)

function Intervall_Start: string;
(* Programmstart-Zeitpunkt *)

function Intervall_Stop: string;
(* Programmende-Zeitpunkt *)

function Intervall_Dauer: string;
(* Programmdauer Stop minus Start *)

procedure Steche_Moment;
(* GetDate und GetTime *)

procedure Konvert_Timestamp(t: string);
(* erstellt den Moment aus String timestamp *)

procedure Formate_Moment(M: Moment);
(* Formatiert die Werte im Moment *)

procedure Zeige_Formate;
(* Zeigt die formatierten Werte im Moment an *)

{$IFDEF DOS}
procedure Normiere_Moment(var M: Moment);
(* Normieren des Momentes nach Vernderung *)

procedure Dezimale_Moment(var M: Moment);
(* Umrechnen Momente in absolute Zahlen *)

procedure Entpacke_Moment(var M: Moment);
(* rechnet die absoluten MS um in einen Zeitpunkt *)

function Gueltig_Moment(var M: Moment): boolean;
(* Stehen im Moment gltige Werte? *)
{$ENDIF}

function Gueltig_Werte(gjahr, gmonat, gtag, gstunde,
                       gminute, gsekunde, gmsek: longint): boolean;
(* Sind diese Werte gltig? *)

function  Historisch_Test_Moment: boolean;
(* Ist Test_Moment < Akt_Moment *)

procedure Manuell_Moment(var M: Moment; mjahr, mmonat, mtag,
                         mstunde, mminute, msekunde, mmsek: longint);
(* dem Moment die Werte zuweisen *)

procedure Addiere_Moment(var M: Moment;
                         ajahr, amonat, atag, astunde, aminute, asekunde, amsek: longint);
(* dem Moment die Werte aufaddieren *)

procedure Differenz_Moment;
(* Diff_Moment = Akt_Moment - Test_Moment *)

{$IFDEF DOS}
procedure SetzeNull_Summe_Moment;
(* Setzt Summe_Moment auf Null *)

procedure Addiere_Summe_Moment;
(* Summe_Moment = Summe_Moment + Diff_Moment *)
{$ENDIF}

procedure Zeige_Feiertage;
(* Zeige die Feiertage zum aktuellen Moment *)

procedure Zeige_Alle_Feiertage;
(* Zeige alle Feiertage des aktuellen Jahres, sortiert :-) *)

procedure Loesche_Alle_Feiertage;
(* Lsche alle Feiertage des aktuellen Jahres *)

function Feiertage_Bestimmen(OST_JAHR: integer): boolean;
(* Bestimmt fr ein Jahr die Feiertage... *)

procedure Feiertage_Eintragen(var M: Moment);
(* Schaut nach, ob in der Feiertagstabelle Eintrge fr den Akt_Moment sind? *)

procedure Feiertage_Sortieren;
(* Sortiert die aktuellen Feiertage *)

procedure Neuer_Feiertag_Nach_Datum(F_TAG, F_MON: integer; F_NAME: string);
(* Fgt einen neuen Feiertag hinzu mit TT.MM.JJJJ *)

procedure Neuer_Feiertag_Wochentag_ab_Datum(F_TAG, F_MON: integer; F_NAME, F_WOCHENTAG: string);
(* Fgt einen neuen Feiertag hinzu, fester Wochentag ab TT.MM.JJJJ *)

procedure Neuer_Feiertag_Nach_AbsTag(F_ABS: integer; F_NAME: string);
(* Fgt einen neuen Feiertag hinzu, "absoluter" Tag im Jahr *)
(* Der Tag kann natrlich wie bei Ostern/Pfingsten abhngig berechnet werden *)

implementation

const Wochen_Tage: array [0..7] of string[10] =
      ('Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag',
       'Freitag', 'Sonnabend', 'Sonntag');

      Monatsnamen: array [1..12] of string[9] =
      ('Januar', 'Februar', 'Mrz', 'April','Mai','Juni','Juli',
       'August','September', 'Oktober', 'November','Dezember');

      Monatsende: array [0..13] of integer =
      (31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31);

{$IFNDEF DOS} EinTag: int64 = 1000 * 60 * 60 * 24; {$ENDIF}

var Sicher_Moment: Moment;
    ii: integer;

function schalt(jahr: longint): integer;
begin
   if (jahr mod 4 = 0) and
     ((jahr mod 100 <> 0) or (jahr mod 400 = 0))
      then schalt:=1
      else schalt:=0;
end (* schalt *);

{$IFDEF DOS}
procedure Normiere_Moment(var M: Moment);
var bmonat, bstunde,
    bminute, bsekunde, bmsek: longint;
begin
   with M do begin
      if jahr < 1 then exit;
      (* wenn wir hier negative Jahre angeboten bekommen,
         sind wir mit der Wissenschaft am Ende *)
      while msek < 0 do begin;
         msek:=msek + 100; dec(sekunde);
      end;
      while sekunde < 0 do begin;
         sekunde:=sekunde + 60; dec(minute);
      end;
      while minute < 0 do begin;
         minute:=minute+60; dec(stunde);
      end;
      while stunde < 0 do begin;
         stunde:=stunde + 24; dec(tag);
      end;
      while monat < 1 do begin;
         monat:=monat + 12; dec(jahr);
         if jahr<1 then exit;
      end;

      while tag < 1 do begin;
         Monatsende[2]:=28 + schalt(jahr);
         tag:=tag + Monatsende[monat-1];
         dec(monat);
         if monat < 1 then begin
            monat:=12; dec(jahr);
            if jahr < 1 then exit;
         end;
      end;

      bmsek:=    msek;
      msek:=     msek    mod 100;
      sekunde:=  sekunde + bmsek div 100;
      bsekunde:= sekunde;
      sekunde:=  sekunde mod 60;
      minute:=   minute  + bsekunde div 60;
      bminute:=  minute;
      minute:=   minute  mod 60;
      stunde:=   stunde  + bminute  div 60;
      bstunde:=  stunde;
      stunde:=   stunde  mod 24;
      tag:=      tag     + bstunde  div 24;
      bmonat:=   monat;
      monat:=    monat   mod 12;  if monat = 0 then monat:= 12;
      jahr:=     jahr    + ((bmonat - monat) div 12);
      Monatsende[2]:=28 + schalt(jahr);

      while (tag > Monatsende[monat]) do begin;
         tag:= tag - Monatsende[monat];
         if monat < 12
            then INC(monat)
            else begin; monat:=1; INC(jahr); end;
         Monatsende[2]:=28 + schalt(jahr);
      end;
      Dezimale_Moment(M);
      wotag:=(abstag mod 7) + 1;
   end;
end  (* Normiere_Moment *);

(* weist die "normalen" Variablen den Word zu *)
procedure Lese_W_Moment(VAR M: Moment);
begin
   with M do begin
      wjahr:=  jahr;   wmonat:= monat;  wtag:=    tag;     wwotag:=wotag;
      wstunde:=stunde; wminute:=minute; wsekunde:=sekunde; wmsek:= msek;
   end;
end;

(* schreibt die word in die "normalen" Variablen *)
procedure Schreibe_W_Moment(VAR M: Moment);
begin
   with M do begin
      jahr:=  wjahr;   monat:= wmonat;  tag:=    wtag;     wotag:=wwotag;
      stunde:=wstunde; minute:=wminute; sekunde:=wsekunde; msek:= wmsek;
   end;
end;

procedure Dezimale_Moment(var M: Moment);
var dmonate,djahre:longint;
begin
   with M do begin
      abstag:= tag - 1;
      dmonate:=monat - 1;
      djahre:= jahr - 1;
      Monatsende[2]:=28 + schalt(jahr);

      while dmonate > 0 do begin;
         abstag:=abstag + Monatsende[dmonate];
         dec(dmonate);
      end;
      while djahre > 0 do begin;
         abstag:=abstag + 365 + schalt(djahre);
         dec(djahre);
      end;

      absMS:=abstag;
      absMS:=absMS   * 8640000 +
             stunde  *  360000 +
             minute  *    6000 +
             sekunde *     100 +
             msek;
      abssek:=INT(absMS/100.00);
      wotag:=(abstag mod 7) + 1;
   end;
end (* Dezimale_Moment *);

(* rechnet die absoluten MS um in einen Zeitpunkt *)
procedure Entpacke_Moment(var M: Moment);
var etag, nbis : longint; sicher, {$IFDEF DOSFPC} rest {$ELSE} schwelle {$ENDIF} : double;
begin
   with M do begin
      sicher:=absMS;
   {$IFDEF DOSFPC}
      (* (hoffentlich) verlustarmer Gleitkomma Modulus :-)
         ca 10% schneller als die do-whiles mit dem Schwellwert.
         Leider werden die TRUNC/ROUND-Zwischenergebnisse fr 16bit zu gro,
         so da dieses extra fr DOS entworfene Verfahren doch nicht verwendet
         werden kann unter Turbo-Pascal.
         Es wird aber benutzt in der Unit ZEIT08 fr NOTDEF DOS :-) *)
      rest:=(absMS / 100.0) - TRUNC(absMS / 100.0);
      msek:=ROUND(100.0 * rest);
      absMS:=(absMS - msek) / 100.0;
      rest:=(absMS / 60.0) - TRUNC(absMS / 60.0);
      sekunde:=ROUND(60.0 * rest);
      absMS:=(absMS - sekunde) / 60.0;
      rest:=(absMS / 60.0) - TRUNC(absMS / 60.0);
      minute:=ROUND(60.0 * rest);
      absMS:=(absMS - minute) / 60.0;
      rest:=(absMS / 24.0) - TRUNC(absMS / 24.0);
      stunde:=ROUND(24.0 * rest);
      absMS:=(absMS - stunde) / 24.0;
      etag:=TRUNC(absMS);
   {$ELSE}
      etag:=0;
      schwelle:=1000. * 24 * 3600 * 100.;
      while absMS >= schwelle  do begin
         inc(etag, 1000); absMS:=absMS - schwelle;
      end;
      schwelle:=24 * 3600 * 100.;
      while absMS >= schwelle  do begin
         inc(etag); absMS:=absMS - schwelle;
      end;
      stunde:=0;
      schwelle:=3600 * 100;
      while absMS >= schwelle  do begin
         inc(stunde); absMS:=absMS - schwelle;
      end;
      minute:=0;
      schwelle:=60 * 100;
      while absMS >= schwelle  do begin
         inc(minute); absMS:=absMS - schwelle;
      end;
      sekunde:=0;
      schwelle:=100;
      while absMS >= schwelle  do begin
         inc(sekunde); absMS:=absMS - schwelle;
      end;
      msek:=TRUNC(absMS);
   {$ENDIF}
      absMS:=sicher;
      jahr:=1; monat:=1; tag:=1;
      monatsende[2]:=28 + schalt(jahr);
      while etag > 0 do begin
         nbis:=monatsende[monat] - tag + 1;
         if nbis > etag then nbis:=1;
         inc(tag, nbis); (* bevorzugt ganze Monate :-) *)
         if tag > monatsende[monat] then begin
            inc(monat); tag:=1;
            if monat > 12 then begin
               inc(jahr); monat:=1;
               monatsende[2]:=28 + schalt(jahr);
            end;
         end;
         dec(etag, nbis);
      end;
   end;
   Dezimale_Moment(M);
end; (* Entpacke_Moment *)

{$ELSE}

(* entpacke das DT in Word und weise sie in die "normalen" Variablen *)
procedure Entpacke_Moment(VAR M: Moment);
begin
   with M do begin
      DecodeDate(absDT, wjahr, wmonat, wtag);
      DecodeTime(absDT, wstunde, wminute, wsekunde, wmsek);

      wwotag:=DayOfWeek(absDT) - 1; if wwotag=0 then wwotag:=7;
      jahr:=  wjahr;   monat:= wmonat;  tag:=    wtag;     wotag:=wwotag;
      stunde:=wstunde; minute:=wminute; sekunde:=wsekunde; msek:= wmsek;
   end;
end;
{$ENDIF}

procedure Steche_Moment;
begin
   with Akt_Moment do begin
{$IFDEF DOS}
      GetDate(wjahr, wmonat, wtag, wwotag);
      GetTime(wstunde, wminute, wsekunde, wmsek);
      Schreibe_W_Moment(Akt_Moment);
      Dezimale_Moment(Akt_Moment);
{$ELSE}
      absDT:=now;
      absTS:=DateTimeToTimeStamp(absDT);
      absMS:=int64(TimeStampToMSecs(absTS));
{$ENDIF}
   end;
end (* Steche_Moment *);

function StopUhr(Kommentar: string): string;
var KM:string;
begin
   KM:=Kommentar; if KM=':' then KM:='StopUhr:';
   Steche_Moment;
   Formate_Moment(Akt_Moment);
   StopUhr:=KM+Formate.TimeStamp;
end (* Stop_Uhr *);

function Intervall_Start: string;
begin
   Intervall_Start:=StopUhr('Start:');
   Test_Moment:=Akt_Moment;
end;

function Intervall_Stop: string;
begin
   Intervall_Stop:=StopUhr('Stop:');
end;

function Intervall_Dauer: string;
var dauer:string;
begin
   Differenz_Moment;
   if Diff_Moment.rsekunde >= 0
      then dauer:=COPY(Diff_TimeStamp, 10, 255)
      else dauer:='Negativ??? :-)';
   if Diff_Moment.rtag >= 1
      then dauer:=StrLong(Trunc(Diff_Moment.rtag))+'T '+dauer;
   Intervall_dauer:='Dauer:'+dauer;
end;

procedure Konvert_Timestamp(t: string);
var {$IFDEF DOS} kjahr, kmonat, ktag,
                 kstunde, kminute, ksekunde, kmsek: longint;
                 w: word;
    {$ELSE}      i, k, e: word;
    {$ENDIF}
begin
{$IFDEF DOS}
   val(copy(t,1,2),  ktag, w);     val(copy(t,4,2),  kmonat, w);  val(copy(t,7,4),  kjahr, w);
   val(copy(t,12,2), kstunde, w);  val(copy(t,15,2), kminute, w); val(copy(t,18,2), ksekunde ,w);
   val(copy(t,21,2), kmsek, w);
   Manuell_Moment(Akt_Moment, kjahr, kmonat, ktag, kstunde, kminute, ksekunde, kmsek);
{$ELSE}
  with Akt_Moment do begin
      (* StrToDateTime geht schlampig mit den ms um,
        daher: machen wir sie hier mindestens dreistellig *)
      k:=POS(',', t); e:=length(t);
      if k > 0 then
         for i:=e+1 to k+3 do t:=t+'0';

      absDT:=StrToDateTime(t);
      absTS:=DateTimeToTimeStamp(absDT);
      absMS:=int64(TimeStampToMSecs(absTS));
   end;
{$ENDIF}
   Formate_Moment(Akt_Moment);
end;

procedure Formate_Moment(M: Moment);
begin
   with M do begin
{$IFDEF DOS} Lese_W_Moment(M);
{$ELSE}      Entpacke_Moment(M);
{$ENDIF}
      Formate.Wochentag    := Wochen_Tage[wwotag];
      Formate.TT_MM_JJ     := str0(wtag, 2) +'.'+
                              str0(wmonat, 2) +'.'+
                              str0(wjahr mod 100, 2);
      Formate.TT_MM_JJJJ   := str0(wtag ,2) + '.'+
                              str0(wmonat, 2) +'.'+
                              str0(wjahr, 4);
      Formate.JJJJ_MM_TT   := str0(wjahr, 4) +'-'+
                              str0(wmonat, 2) +'-'+
                              str0(wtag, 2);
      Formate.HH_MM_SS     := str0(wstunde, 2) +':'+
                              str0(wminute, 2) +':'+
                              str0(wsekunde, 2);
      Formate.HH_MM_SS_MS  := str0(wstunde, 2) +':'+
                              str0(wminute, 2) +':'+
                              str0(wsekunde, 2) +','+
                              {$IFDEF DOS} str0(wmsek, 2);
                              {$ELSE}      str0(wmsek, 3);
                              {$ENDIF}
      Formate.Timestamp    := str0(wtag, 2) +'.'+
                              str0(wmonat, 2) +'.'+
                              str0(wjahr, 4) +' '+
                              Formate.HH_MM_SS_MS;
      Formate.DdatumTzeit  := 'D'+str0(wjahr, 4)+
                              str0(wmonat, 2)+
                              str0(wtag, 2)+
                              'T'+str0(wstunde, 2)+
                              str0(wminute, 2)+
                              str0(wsekunde, 2)+
                              {$IFDEF DOS} str0(wmsek, 2);
                              {$ELSE}      str0(wmsek, 3);
                              {$ENDIF}
      Formate.Ddatum       := 'D'+str0(wjahr, 4)+
                              str0(wmonat, 2)+
                              str0(wtag, 2);
      Formate.Datum_Zeit   := Formate.Wochentag +', '+
                              str0(wtag, 2) +'.'+
                              Monatsnamen[wmonat] +' '+
                              str0(wjahr, 4) +', ' +
                              Formate.HH_MM_SS;
      Formate.Abs_Tag      := {$IFDEF DOS} strlong(abstag);
                              {$ELSE}      strlong(absTS.date-1);
                              {$ENDIF}
      Formate.Abs_MS       := {$IFDEF DOS} strdouble(absMS);
                              {$ELSE}      strint64(absMS-EinTag);
                              {$ENDIF}
   end;
end (* Formate_Moment *);

procedure Zeige_Formate;
begin
   WriteLn('Wochentag     = ',Formate.Wochentag);
   WriteLn('TT.MM.JJ      = ',Formate.TT_MM_JJ);
   WriteLn('TT.MM.JJJJ    = ',Formate.TT_MM_JJJJ);
   WriteLn('JJJJ-MM-TT    = ',Formate.JJJJ_MM_TT);
   WriteLn('HH:MM:SS      = ',Formate.HH_MM_SS);
   WriteLn('HH:MM:SS,MS   = ',Formate.HH_MM_SS_MS);
   WriteLn('Timestamp     = ',Formate.Timestamp);
   WriteLn('Datum/Zeit    = ',Formate.Datum_Zeit);
   WriteLn('absolute Zeit = ',Formate.Abs_Tag,' Tage == ',
                 {$IFDEF DOS} Formate.Abs_ms, ' HS');
                 {$ELSE}      Formate.Abs_ms, ' ms');
                 {$ENDIF}
end (* Zeige_Format *);

{$IFDEF DOS}
(* Diese Funktion ist exclusiv fr TOLLZEIT :-) *)
function Gueltig_Moment(var M: Moment): boolean;
begin
   with M do Gueltig_Moment:=
      Gueltig_Werte(jahr, monat, tag, stunde, minute, sekunde, msek);
end (* Gueltig_Moment *);
{$ENDIF}

function Gueltig_Werte(gjahr, gmonat, gtag, gstunde, gminute, gsekunde, gmsek: longint): boolean;
begin
   Gueltig_Werte:=true;
   if gjahr <= 0 then Gueltig_Werte:=false;
   Monatsende[2]:=28 + schalt(gjahr);
   if (gtag < 1) or
      (gmonat < 1) or (gmonat > 12) or
      (gtag > Monatsende[gmonat])        then Gueltig_Werte:=false;
   if (gstunde  < 0) or (gstunde  > 23)  then Gueltig_Werte:=false;
   if (gminute  < 0) or (gminute  > 59)  then Gueltig_Werte:=false;
   if (gsekunde < 0) or (gsekunde > 59)  then Gueltig_Werte:=false;
   if (gmsek    < 0) or (gmsek    > 99)  then Gueltig_Werte:=false;
end (* Gueltig_Werte *);

function Historisch_Test_Moment: boolean;
begin
{$IFDEF DOS} Dezimale_Moment(Test_Moment);
             Dezimale_Moment(Akt_Moment);
{$ENDIF}
   Historisch_Test_Moment:=(Test_Moment.absMS < Akt_Moment.absMS);
end (* Historisch_Moment *);

procedure Manuell_Moment(var M: Moment;
                         mjahr, mmonat, mtag, mstunde, mminute, msekunde, mmsek: longint);
begin
   with M do begin
{$IFDEF DOS}
      jahr:=  mjahr;   monat:= mmonat;  tag:=    mtag;
      stunde:=mstunde; minute:=mminute; sekunde:=msekunde; msek:=mmsek;
      Normiere_Moment(M);
{$ELSE}
      absDT:=StrToDateTime(str0long(mtag, 2) +'.'+
             str0long(mmonat, 2) +'.'+
             str0long(mjahr, 4) +' '+
             str0long(mstunde, 2) +':'+
             str0long(mminute, 2) +':'+
             str0long(msekunde, 2) +','+
             str0long(mmsek, 3));
      absTS:=DateTimeToTimeStamp(absDT);
      absMS:=int64(TimeStampToMSecs(absTS));
{$ENDIF}
   end;
end (* Manuell_Moment *);

procedure Addiere_Moment(var M: Moment;
                         ajahr, amonat, atag, astunde, aminute, asekunde, amsek: longint);
begin
   with M do begin
{$IFDEF DOS}
      if ajahr <> 0    then jahr:=   jahr    + ajahr;
      if amonat <> 0   then monat:=  monat   + amonat;
      if atag <> 0     then tag:=    tag     + atag;
      if astunde <> 0  then stunde:= stunde  + astunde;
      if aminute <> 0  then minute:= minute  + aminute;
      if asekunde <> 0 then sekunde:=sekunde + asekunde;
      if amsek <> 0    then msek:=   msek    + amsek;
      Normiere_Moment(M);
{$ELSE}
      if ajahr <> 0    then absDT:=IncYear(absDT, ajahr);
      if amonat <> 0   then absDT:=IncMonth(absDT, amonat);
      if atag <> 0     then absDT:=IncDay(absDT, atag);
      if astunde <> 0  then absDT:=IncHour(absDT, astunde);
      if aminute <> 0  then absDT:=IncMinute(absDT, aminute);
      if asekunde <> 0 then absDT:=IncSecond(absDT, asekunde);
      if amsek <> 0    then absDT:=IncMilliSecond(absDT, amsek);
      absTS:=DateTimeToTimeStamp(absDT);
      absMS:=int64(TimeStampToMSecs(absTS));
{$ENDIF}
   end;
end (* Addiere_Moment *);

procedure Differenz_Moment;
var reverse: boolean;
    von, bis: Moment;
begin
{$IFNDEF DOS}
   Entpacke_Moment(Akt_Moment);
   Entpacke_Moment(Test_Moment);
{$ENDIF}
   if Historisch_Test_Moment
      then begin
         reverse:=false;
         von:=Test_Moment; bis:=Akt_Moment;
      end
      else begin
         reverse:=true;
         von:=Akt_Moment; bis:=Test_Moment;
      end;

   with Diff_Moment do begin
      if bis.msek > von.msek-1
         then imsek:=bis.msek - von.msek
         else begin;
            imsek:=bis.msek +
                   {$IFDEF DOS} 100 {$ELSE} 1000 {$ENDIF} - von.msek;
            dec(bis.sekunde)
      end;
      if bis.sekunde > von.sekunde-1
         then isekunde:=bis.sekunde - von.sekunde
         else begin;
            isekunde:=bis.sekunde + 60 - von.sekunde;
            dec(bis.minute)
      end;
      if bis.minute > von.minute-1
         then iminute:=bis.minute - von.minute
         else begin;
            iminute:=bis.minute + 60 - von.minute;
            dec(bis.stunde)
      end;
      if bis.stunde > von.stunde-1
         then istunde:=bis.stunde - von.stunde
         else begin;
            istunde:=bis.stunde + 24 - von.stunde;
            dec(bis.tag)
      end;
      Monatsende[2]:=28 + schalt(von.jahr);
      if bis.tag > von.tag-1
         then itag:=bis.tag - von.tag
         else begin;
            if reverse
               then itag:=bis.tag + Monatsende[von.monat] - von.tag
               else itag:=bis.tag + Monatsende[bis.monat-1] - von.tag;
            dec(bis.monat)
      end;
      if bis.monat > von.monat-1
         then imonat:=bis.monat - von.monat
         else begin;
            imonat:=bis.monat+ 12 -von.monat;
            dec(bis.jahr)
      end;
      ijahr:=bis.jahr - von.jahr;

      if reverse then begin
         ijahr:=-ijahr; imonat:=-imonat; itag:=-itag;
         istunde:=-istunde; iminute:=-iminute; isekunde:=-isekunde; imsek:=-imsek;
      end;
      rsekunde:= Akt_Moment.absMS - Test_Moment.absMS;
      rsekunde:= rsekunde / {$IFDEF DOS} 100.00;
                            {$ELSE}      1000.0;
                            {$ENDIF}
      rminute:=  rsekunde / 60.00;
      rstunde:=  rminute  / 60.00;
      rtag:=     rstunde  / 24.00;
      rjahr:=    rtag     / 365.22;
      rmonat:=   rjahr    * 12.00;
      rwoche:=   rtag     / 7.00;

      if rsekunde >= 0
         then begin
            Diff_TimeStamp:=str0long(itag, 2) +'.'+
                            str0long(imonat, 2) +'.'+
                            str0long(ijahr, 2) +' '+
                            str0long(istunde, 2) +':'+
                            str0long(iminute, 2) +':'+
                            str0long(isekunde, 2) +','+
               {$IFDEF DOS} str0long(imsek, 2);
               {$ELSE}      str0long(imsek, 3);
               {$ENDIF}
            (* die Monate/Jahre vernachlssigen wir hier bis zum Beweis des Gegenteils *)
            Diff_TimeStamp24:=str0long(istunde + 24*itag, 2) +':'+
                              str0long(iminute, 2) +':'+
                              str0long(isekunde, 2) +','+
                 {$IFDEF DOS} str0long(imsek, 2);
                 {$ELSE}      str0long(imsek, 3);
                 {$ENDIF}
            Diff_Einzel:=str0long(ijahr, 2) +' Jahre '+
                         str0long(imonat ,2) +' Monate '+
                         str0long(itag, 2) +' Tage, '+
                         str0long(istunde, 2) +':'+
                         str0long(iminute, 2) +':'+
                         str0long(isekunde, 2) +','+
            {$IFDEF DOS} str0long(imsek, 2);
            {$ELSE}      str0long(imsek, 3);
            {$ENDIF}
         end
         else begin
            Diff_TimeStamp:=strlong(itag) +'/'+
                            strlong(imonat) +'/'+
                            strlong(ijahr) +' '+
                            strlong(istunde) +'/'+
                            strlong(iminute) +'/'+
                            strlong(isekunde )+'/'+
                            strlong(imsek);
            (* die Monate/Jahre vernachlssigen wir hier bis zum Beweis des Gegenteils *)
            Diff_TimeStamp24:=strlong(istunde + 24*itag) +'/'+
                              strlong(iminute) +'/'+
                              strlong(isekunde) +'/'+
                              strlong(imsek);
            Diff_Einzel:=strlong(ijahr) +' Jahre '+
                         strlong(imonat) +' Monate '+
                         strlong(itag) +' Tage, '+
                         strlong(istunde) +'/'+
                         strlong(iminute) +'/'+
                         strlong(isekunde) +'/'+
                         strlong(imsek);
      end;
      Diff_Abs_Sekunden:=
            {$IFDEF DOS} strkdouble(rsekunde, 2) +' s';
            {$ELSE}      strkdouble(rsekunde, 3) +' s';
            {$ENDIF}
      Diff_Abs_Jahre:=strkdouble(rjahr, 3) +' Jahre';
      Diff_Abs_Monate:=strkdouble(rmonat, 3) +' Monate';
      Diff_Abs_Wochen:=strkdouble(rwoche, 3) +' Wochen';
      Diff_Abs_Tage:=strkdouble(rtag, 3)+' Tage';
      Diff_Abs_Stunden:=strkdouble(rstunde, 3) +' h';
      Diff_Abs_Minuten:=strkdouble(rminute, 3) +' min';
      Diff_Abs:=Diff_Abs_Jahre +' / '+
                Diff_Abs_Monate +' / '+
                Diff_Abs_Wochen +' / '+
                Diff_Abs_Tage +' / '+
                Diff_Abs_Stunden +' / '+
                Diff_Abs_Minuten +' / '+
                Diff_Abs_Sekunden;
   end; (* with Diff_Moment *)
end (* Differenz_Moment *);

{$IFDEF DOS}
procedure Addiere_Summe_Moment;
begin
   with Summe_Moment do begin
      imsek   := imsek    + Diff_Moment.imsek;
      isekunde:= isekunde + Diff_Moment.isekunde;
      iminute := iminute  + Diff_Moment.iminute;
      istunde := istunde  + Diff_Moment.istunde;
      itag    := itag     + Diff_Moment.itag;
      imonat  := imonat   + Diff_Moment.imonat;
      ijahr   := ijahr    + Diff_Moment.ijahr;
      while imsek>99 do begin
         dec(imsek,100); inc(isekunde);
      end;
      while isekunde>59 do begin
         dec(isekunde,60); inc(iminute);
      end;
      while iminute>59 do begin
         dec(iminute,60); inc(istunde);
      end;
      while istunde>23 do begin
         dec(istunde,24); inc(itag);
      end;
      while itag>30 do begin
         dec(itag,31); inc(imonat);
      end;
      while imonat>11 do begin
         dec(imonat,12); inc(ijahr);
      end;
      rsekunde:= imsek    * 1.0;
      rsekunde:= rsekunde / 100.00;
      rminute:=  rsekunde / 60.00;
      rstunde:=  rminute  / 60.00;
      rtag:=     rstunde  / 24.00;
      rjahr:=    rtag     / 365.22;
      rmonat:=   rjahr    * 12.00;
      rwoche:=   rtag     / 7.00;
      Summe_TimeStamp:=str0long(itag, 2) +'.'+
                       str0long(imonat, 2) +'.'+
                       str0long(ijahr, 4) +' '+
                       str0long(istunde, 2) +':'+
                       str0long(iminute, 2) +':'+
                       str0long(isekunde, 2) +','+
                       str0long(imsek,2);
      (* die Monate/Jahre vernachlssigen wir hier bis zum Beweis des Gegenteils *)
      Summe_TimeStamp24:=str0long(istunde+ 24*itag, 2) +':'+
                         str0long(iminute, 2) +':'+
                         str0long(isekunde, 2) +','+
                         str0long(imsek, 2);
   end;
end (* Addiere_Summe_Moment *);

procedure SetzeNull_Summe_Moment;
begin
   with Summe_Moment do begin
      imsek:= 0; isekunde:= 0; iminute:= 0; istunde:= 0;
      itag:= 0;  imonat:= 0;   ijahr:= 0;
      rsekunde:= 0.0; rminute:= 0.0; rstunde:= 0.0;
      rtag:= 0.0;     rjahr:= 0.0;   rmonat:= 0.0; rwoche:= 0.0;
      Summe_TimeStamp:='00.00.0000 00:00:00,00';
      (* die Monate/Jahre vernachlssigen wir hier bis zum Beweis des Gegenteils *)
      Summe_TimeStamp24:='00:00:00,00';
   end;
end (* SetzeNull_Summe_Moment *);
{$ENDIF}

procedure Zeige_Feiertage;
var f: integer;
begin
  with Akt_Moment do begin
     for f:=1 to heute_Feiertag do begin
        Write(welcher_Feiertag[f]);
        if f < heute_Feiertag then write(' und ');
  end end;
  if Akt_Moment.heute_Feiertag > 0 then WriteLn;
end; (* Zeige_Feiertage *)

procedure Zeige_Alle_Feiertage;
var f,i:integer;
begin
  with Feiertage do begin
     WriteLn('Jahr: ', ftJahr, ' Anzahl: ', ftANZAHL);
     for f:=1 to ftANZAHL do (* im Rang steht das sortierte nIMJAHR *)
        for i:=1 to ftANZAHL do with FT[i] do begin
           if ftRANG=f then
              WriteLn(f,':',ftNAME,' am ',nTAG,'.',nMONAT,'.',ftJAHR,
                        ' nIMJAHR=',nIMJAHR,' WT ',nWOCHENTAG,'(',nWOTAG,')',
                        ' kette=',nKETTE,' Rang=',ftRANG);
  end end;
end; (* Zeige_Alle_Feiertage *)

procedure Loesche_Alle_Feiertage;
var i: integer;
begin
  with Feiertage do begin
     ftJAHR:=0; ftANZAHL:=0;
     for i:=1 to 50 do with FT[i] do begin
        ftRANG:=0; ftNAME:='';
        nTAG:=0; nMONAT:=0; nIMJAHR:=0;
        nWOCHENTAG:=''; nWOTAG:=0; nKETTE:='';
  end end;
end; (* Loesche_Alle_Feiertage *)

function Feiertage_Bestimmen(OST_JAHR: integer): boolean;
var OST_N, OST_A, OST_B, OST_M, OST_Q, OST_W: integer;
    OST_TAG, OST_MON, OST_ABS, TAG_ABS: integer;
begin
   with Feiertage do begin
      ftJAHR:=OST_JAHR; ftANZAHL:=0;
      if (OST_JAHR < 1900 ) or (OST_JAHR > 2099) then begin;
         ftANZAHL:=0; Feiertage_Bestimmen:=false; exit
      end;
      OST_N  := OST_JAHR - 1900;
      OST_A  := OST_N mod 19;
      OST_B  :=( 7*OST_A + 1) div 19;
      OST_M  :=(11*OST_A + 4 - OST_B) mod 29;
      OST_Q  := OST_N div 4;
      OST_W  :=(OST_N + OST_Q + 31 - OST_M) mod 7;
      OST_TAG:= 25 - OST_M - OST_W;
      if OST_TAG < 1
         then begin OST_MON:=3; OST_TAG:=OST_TAG+31; end
         else       OST_MON:=4;
      Feiertage_Bestimmen:=true;
      Neuer_Feiertag_Nach_Datum(OST_TAG, OST_MON, 'Ostersonntag');
      OST_ABS:=FT[1].nIMJAHR;
      Neuer_Feiertag_Nach_ABSTag(OST_ABS +  1, 'Ostermontag');
      Neuer_Feiertag_Nach_ABSTag(OST_ABS -  2, 'Karfreitag');
      Neuer_Feiertag_Nach_ABSTag(OST_ABS + 39, 'Himmelfahrt');
      Neuer_Feiertag_Nach_ABSTag(OST_ABS - 52, 'Weiberfastnacht');
      Neuer_Feiertag_Nach_ABSTag(OST_ABS - 48, 'Rosenmontag');
      Neuer_Feiertag_Nach_ABSTag(OST_ABS - 47, 'Fastnacht');
      Neuer_Feiertag_Nach_ABSTag(OST_ABS - 46, 'Aschermittwoch');
      Neuer_Feiertag_Nach_ABSTag(OST_ABS + 49, 'Pfingstsonntag');
      Neuer_Feiertag_Nach_ABSTag(OST_ABS + 50, 'Pfingstmontag');
      if HappyKadaver then Neuer_Feiertag_Nach_ABSTag(OST_ABS + 60, 'Happy Kadaver');
      if Reformationstag then Neuer_Feiertag_Nach_Datum(31, 10, 'Reformationstag');
      if AlleHeimlichen then Neuer_Feiertag_Nach_Datum(1 ,11, 'AlleHeimlichen');
      if DreiKoenige then Neuer_Feiertag_Nach_Datum(6, 1, '3 Knige');
      Neuer_Feiertag_Nach_Datum( 1,  7, 'Geburtstag');
      Neuer_Feiertag_Nach_Datum( 1,  5, '1.Mai');
      Neuer_Feiertag_Nach_Datum( 3, 10, '3.Oktober');
      Neuer_Feiertag_Nach_Datum( 1,  1, 'Neujahr');
      Neuer_Feiertag_Nach_Datum(31, 12, 'Silvester');
      Neuer_Feiertag_Nach_Datum(24, 12, 'Heiligabend');
      Neuer_Feiertag_Nach_Datum(25, 12, '1.Weihnachtstag');
      Neuer_Feiertag_Nach_Datum(26, 12, '2.Weihnachtstag');
      Neuer_Feiertag_Wochentag_ab_Datum( 8 , 5, 'Muttertag', 'Sonntag');
      Neuer_Feiertag_Wochentag_ab_Datum(18, 12, '4.Advent', 'Sonntag');
      TAG_ABS:=FT[ftANZAHL].nIMJAHR;
      Neuer_Feiertag_Nach_ABSTag(TAG_ABS -21, '1.Advent');
      Neuer_Feiertag_Nach_ABSTag(TAG_ABS -14, '2.Advent');
      Neuer_Feiertag_Nach_ABSTag(TAG_ABS  -7, '3.Advent');
      Feiertage_Sortieren;
end end (* Feiertage bestimmen *);

procedure Feiertage_Sortieren;
var sor_I, sor_K, sor_INDEX, sor_MINIMUM: integer;
begin
   with Feiertage do begin
   for sor_I:=1 to ftANZAHL do with FT[sor_I] do ftRANG:=0;
   for sor_I:=1 to ftANZAHL do with FT[sor_I] do begin;
      sor_MINIMUM:=999; sor_INDEX:=0;
      for sor_K:=1 to ftANZAHL do with FT[sor_K] do begin;
         if (nIMJAHR<sor_MINIMUM) and (ftRANG=0) then begin
            sor_INDEX:=sor_K; sor_MINIMUM:=nIMJAHR;
         end;
      end;
      FT[sor_INDEX].ftRANG:=sor_I;
   end end;
end (* Feiertage_Sortieren *);

procedure Neuer_Feiertag_Nach_Datum(F_TAG, F_MON: integer; F_NAME: string);
begin
   Sicher_Moment:=Akt_Moment;
   inc(Feiertage.ftANZAHL); if Feiertage.ftANZAHL > 50 then Feiertage.ftANZAHL:=1;
   with Feiertage do with FT[ftANZAHL] do begin
      Manuell_Moment(Akt_Moment, ftJAHR, F_MON, F_TAG, 0, 0, 0, 0);
      Manuell_Moment(Test_Moment ,ftJAHR, 1, 1, 0, 0, 0, 0);
      Differenz_Moment;
      Formate_Moment(Akt_Moment);
      with Akt_Moment do with Formate do begin
         ftNAME:=F_NAME; nIMJAHR:=TRUNC(Diff_Moment.rtag) + 1; ftRANG:=0;
         {$IFDEF DOS} Lese_W_Moment(Akt_Moment);
         {$ELSE}      Entpacke_Moment(Akt_Moment);
         {$ENDIF}
         nTAG:=wtag; nMONAT:=wmonat; nKETTE:=TT_MM_JJJJ;
         nWOTAG:=wwotag; nWOCHENTAG:=Formate.WochenTag; nKETTE:=TT_MM_JJJJ;
   end end;
   Akt_Moment:=Sicher_Moment;
end (* Neuer_Feiertag_Nach_Datum *);

procedure Neuer_Feiertag_Wochentag_ab_Datum(F_TAG, F_MON: integer; F_NAME, F_WOCHENTAG: string);
begin
   Sicher_Moment:=Akt_Moment;
   inc(Feiertage.ftANZAHL); if Feiertage.ftANZAHL > 50 then Feiertage.ftANZAHL:=1;
   with Feiertage do with FT[ftANZAHL] do begin
      Manuell_Moment(Akt_Moment, ftJAHR, F_MON, F_TAG, 0, 0, 0, 0);
      Manuell_Moment(Test_Moment,ftJAHR, 1, 1, 0, 0, 0, 0);
      Differenz_Moment;
      Formate_Moment(Akt_Moment);
      nIMJAHR:=TRUNC(Diff_Moment.rtag) + 1;
      repeat
         Formate_Moment(Akt_Moment);
         with Akt_Moment do with Formate do begin
            ftNAME:=F_NAME;  ftRANG:=0;
            {$IFDEF DOS} Lese_W_Moment(Akt_Moment);
            {$ELSE}      Entpacke_Moment(Akt_Moment);
            {$ENDIF}
            nTAG:=wtag; nMONAT:=wmonat; nKETTE:=TT_MM_JJJJ;
            nWOTAG:=wwotag; nWOCHENTAG:=Formate.WochenTag;
            if nWOCHENTAG <> F_WOCHENTAG then begin;
               Addiere_Moment(Akt_Moment, 0, 0, 1, 0, 0, 0, 0);
               inc(nIMJAHR);
            end
         end
      until (nWOCHENTAG = F_WOCHENTAG) or ((nTAG = 31) and (nMONAT = 12));
   end;
   Akt_Moment:=Sicher_Moment;
end (* Neuer_Feiertag_Wochentage_ab_Datum *);

procedure Neuer_Feiertag_Nach_AbsTag(F_ABS: integer; F_NAME: string);
begin
   Sicher_Moment:=Akt_Moment;
   inc(Feiertage.ftANZAHL); if Feiertage.ftANZAHL > 50 then Feiertage.ftANZAHL:=1;
   with Feiertage do with FT[ftANZAHL] do begin
      Manuell_Moment(Akt_Moment, ftJAHR, 1, 1, 0, 0, 0, 0);
      Addiere_Moment(Akt_Moment,0, 0, F_ABS - 1, 0, 0, 0, 0);
      Formate_Moment(Akt_Moment);
      with Akt_Moment do with Formate do begin
         ftNAME:=F_NAME; nIMJAHR:=F_ABS; ftRANG:=0;
         {$IFDEF DOS} Lese_W_Moment(Akt_Moment);
         {$ELSE}      Entpacke_Moment(Akt_Moment);
         {$ENDIF}
         nTAG:=wtag; nMONAT:=wmonat; nKETTE:=TT_MM_JJJJ;
         nWOTAG:=wwotag; nWOCHENTAG:=Formate.WochenTag;
      end
   end;
   Akt_Moment:=Sicher_Moment;
end (* Neuer_Feiertag_Nach_AbsTag *);

procedure Feiertage_Eintragen(var M: Moment);
var jj:integer;
begin
   with M do with Feiertage do begin;
      heute_feiertag:=0;
      for jj:=1 to ftANZAHL do with FT[jj] do
      with M do begin
         {$IFDEF DOS} Lese_W_Moment(M);
         {$ELSE}      Entpacke_Moment(M);
         {$ENDIF}
         if (wjahr = ftJAHR) and (wtag = nTAG) and (wmonat = nMONAT)
         then begin;
            inc(heute_feiertag);
            if heute_feiertag > 5 then heute_feiertag:=1;
            welcher_feiertag[heute_feiertag]:=ftNAME;
         end;
   end; end;
end (* Feiertage eintragen *);

begin
   Feiertage.HappyKadaver:=true;
   Feiertage.Reformationstag:=true;
   Feiertage.AlleHeimlichen:=true;
   Feiertage.DreiKoenige:=true;
   Akt_Moment.heute_feiertag:=0;
   Test_Moment.heute_feiertag:=0;
   for ii:=1 to 5 do begin
      Akt_Moment.welcher_feiertag[ii]:='';
      Test_Moment.welcher_feiertag[ii]:='';
   end;
   with Feiertage do begin ftJAHR:=1966; ftANZAHL:=0; end;
end (* Zeit.TPU *).